rule win_grandoreiro_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.grandoreiro"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c3 51 894210 8b4040 891424 8bd4 83c004 }
            // n = 7, score = 100
            //   c3                   | ret                 
            //   51                   | push                ecx
            //   894210               | mov                 dword ptr [edx + 0x10], eax
            //   8b4040               | mov                 eax, dword ptr [eax + 0x40]
            //   891424               | mov                 dword ptr [esp], edx
            //   8bd4                 | mov                 edx, esp
            //   83c004               | add                 eax, 4

        $sequence_1 = { c1ff02 8b4dd8 66897c8a02 e9???????? c645d040 8a45f4 2a45e4 }
            // n = 7, score = 100
            //   c1ff02               | sar                 edi, 2
            //   8b4dd8               | mov                 ecx, dword ptr [ebp - 0x28]
            //   66897c8a02           | mov                 word ptr [edx + ecx*4 + 2], di
            //   e9????????           |                     
            //   c645d040             | mov                 byte ptr [ebp - 0x30], 0x40
            //   8a45f4               | mov                 al, byte ptr [ebp - 0xc]
            //   2a45e4               | sub                 al, byte ptr [ebp - 0x1c]

        $sequence_2 = { 33c0 898300010000 c78304010000ff000000 8dbbb0000000 be???????? b908000000 f3a5 }
            // n = 7, score = 100
            //   33c0                 | xor                 eax, eax
            //   898300010000         | mov                 dword ptr [ebx + 0x100], eax
            //   c78304010000ff000000     | mov    dword ptr [ebx + 0x104], 0xff
            //   8dbbb0000000         | lea                 edi, [ebx + 0xb0]
            //   be????????           |                     
            //   b908000000           | mov                 ecx, 8
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]

        $sequence_3 = { 7512 b201 8b45f4 8b08 ff91d8000000 e9???????? 8b45f4 }
            // n = 7, score = 100
            //   7512                 | jne                 0x14
            //   b201                 | mov                 dl, 1
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   ff91d8000000         | call                dword ptr [ecx + 0xd8]
            //   e9????????           |                     
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]

        $sequence_4 = { eb14 8b45fc 8b4824 8b45fc 8b5030 8b45f8 e8???????? }
            // n = 7, score = 100
            //   eb14                 | jmp                 0x16
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b4824               | mov                 ecx, dword ptr [eax + 0x24]
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b5030               | mov                 edx, dword ptr [eax + 0x30]
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   e8????????           |                     

        $sequence_5 = { 648922 8d55e8 8bc6 e8???????? 84c0 0f8400010000 84db }
            // n = 7, score = 100
            //   648922               | mov                 dword ptr fs:[edx], esp
            //   8d55e8               | lea                 edx, [ebp - 0x18]
            //   8bc6                 | mov                 eax, esi
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   0f8400010000         | je                  0x106
            //   84db                 | test                bl, bl

        $sequence_6 = { e9???????? 8b45f8 8b4068 80780800 0f84be000000 33c0 55 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   8b4068               | mov                 eax, dword ptr [eax + 0x68]
            //   80780800             | cmp                 byte ptr [eax + 8], 0
            //   0f84be000000         | je                  0xc4
            //   33c0                 | xor                 eax, eax
            //   55                   | push                ebp

        $sequence_7 = { eb08 a1???????? 094660 8bc6 8b10 ff92c0000000 c686e701000001 }
            // n = 7, score = 100
            //   eb08                 | jmp                 0xa
            //   a1????????           |                     
            //   094660               | or                  dword ptr [esi + 0x60], eax
            //   8bc6                 | mov                 eax, esi
            //   8b10                 | mov                 edx, dword ptr [eax]
            //   ff92c0000000         | call                dword ptr [edx + 0xc0]
            //   c686e701000001       | mov                 byte ptr [esi + 0x1e7], 1

        $sequence_8 = { 8b45fc eb03 8b45f4 85c0 7505 b801000000 8b55f8 }
            // n = 7, score = 100
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   eb03                 | jmp                 5
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   85c0                 | test                eax, eax
            //   7505                 | jne                 7
            //   b801000000           | mov                 eax, 1
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]

        $sequence_9 = { 0fb704adbcb77200 66014608 0fb704add4b77200 6601460a 8bd3 8bc6 e8???????? }
            // n = 7, score = 100
            //   0fb704adbcb77200     | movzx               eax, word ptr [ebp*4 + 0x72b7bc]
            //   66014608             | add                 word ptr [esi + 8], ax
            //   0fb704add4b77200     | movzx               eax, word ptr [ebp*4 + 0x72b7d4]
            //   6601460a             | add                 word ptr [esi + 0xa], ax
            //   8bd3                 | mov                 edx, ebx
            //   8bc6                 | mov                 eax, esi
            //   e8????????           |                     

    condition:
        7 of them and filesize < 7602176
}