rule win_gravity_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-05-30"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.4.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.gravity_rat"
        malpedia_rule_date = "20200529"
        malpedia_hash = "92c362319514e5a6da26204961446caa3a8b32a8"
        malpedia_version = "20200529"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using yara-signator.
     * The code and documentation / approach is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { bd0083ed55 a2???????? 97 9d 32903e331837 5f }
            // n = 6, score = 100
            //   bd0083ed55           | mov                 ebp, 0x55ed8300
            //   a2????????           |                     
            //   97                   | xchg                eax, edi
            //   9d                   | popfd               
            //   32903e331837         | xor                 dl, byte ptr [eax + 0x3718333e]
            //   5f                   | pop                 edi

        $sequence_1 = { 6d 6d 92 8d06 ac }
            // n = 5, score = 100
            //   6d                   | insd                dword ptr es:[edi], dx
            //   6d                   | insd                dword ptr es:[edi], dx
            //   92                   | xchg                eax, edx
            //   8d06                 | lea                 eax, [esi]
            //   ac                   | lodsb               al, byte ptr [esi]

        $sequence_2 = { 728a e1ed 47 0000 }
            // n = 4, score = 100
            //   728a                 | jb                  0xffffff8c
            //   e1ed                 | loope               0xffffffef
            //   47                   | inc                 edi
            //   0000                 | add                 byte ptr [eax], al

        $sequence_3 = { 05a652fb26 a2???????? 94 3905???????? }
            // n = 4, score = 100
            //   05a652fb26           | add                 eax, 0x26fb52a6
            //   a2????????           |                     
            //   94                   | xchg                eax, esp
            //   3905????????         |                     

        $sequence_4 = { 25814037bd 7567 d7 8a10 80675e9a 0200 1c9a }
            // n = 7, score = 100
            //   25814037bd           | and                 eax, 0xbd374081
            //   7567                 | jne                 0x69
            //   d7                   | xlatb               
            //   8a10                 | mov                 dl, byte ptr [eax]
            //   80675e9a             | and                 byte ptr [edi + 0x5e], 0x9a
            //   0200                 | add                 al, byte ptr [eax]
            //   1c9a                 | sbb                 al, 0x9a

        $sequence_5 = { c4a71e572e2f 7bf5 0413 084c447b }
            // n = 4, score = 100
            //   c4a71e572e2f         | les                 esp, ptr [edi + 0x2f2e571e]
            //   7bf5                 | jnp                 0xfffffff7
            //   0413                 | add                 al, 0x13
            //   084c447b             | or                  byte ptr [esp + eax*2 + 0x7b], cl

        $sequence_6 = { 71dd 15dbd111e0 37 2506c0e0b7 ffc8 }
            // n = 5, score = 100
            //   71dd                 | jno                 0xffffffdf
            //   15dbd111e0           | adc                 eax, 0xe011d1db
            //   37                   | aaa                 
            //   2506c0e0b7           | and                 eax, 0xb7e0c006
            //   ffc8                 | dec                 eax

        $sequence_7 = { 084c447b d1fb 31b407f2968fe5 ba6f0b0f05 }
            // n = 4, score = 100
            //   084c447b             | or                  byte ptr [esp + eax*2 + 0x7b], cl
            //   d1fb                 | sar                 ebx, 1
            //   31b407f2968fe5       | xor                 dword ptr [edi + eax - 0x1a70690e], esi
            //   ba6f0b0f05           | mov                 edx, 0x50f0b6f

        $sequence_8 = { 8811 f1 b716 6d 2291a7d40e7c }
            // n = 5, score = 100
            //   8811                 | mov                 byte ptr [ecx], dl
            //   f1                   | int1                
            //   b716                 | mov                 bh, 0x16
            //   6d                   | insd                dword ptr es:[edi], dx
            //   2291a7d40e7c         | and                 dl, byte ptr [ecx + 0x7c0ed4a7]

        $sequence_9 = { 40 2d990efcd3 37 5d }
            // n = 4, score = 100
            //   40                   | inc                 eax
            //   2d990efcd3           | sub                 eax, 0xd3fc0e99
            //   37                   | aaa                 
            //   5d                   | pop                 ebp

    condition:
        7 of them and filesize < 1916928
}