rule win_grease_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.grease."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.grease"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 52 50 683f000f00 50 50 50 }
            // n = 6, score = 400
            //   52                   | push                edx
            //   50                   | push                eax
            //   683f000f00           | push                0xf003f
            //   50                   | push                eax
            //   50                   | push                eax
            //   50                   | push                eax

        $sequence_1 = { 4533c0 488bd3 c744242804000000 4889442420 ff15???????? 488b4c2450 ff15???????? }
            // n = 7, score = 300
            //   4533c0               | mov                 dword ptr [esp + 0x60], ebx
            //   488bd3               | dec                 eax
            //   c744242804000000     | mov                 dword ptr [esp + 0x68], ebx
            //   4889442420           | inc                 ebp
            //   ff15????????         |                     
            //   488b4c2450           | xor                 eax, eax
            //   ff15????????         |                     

        $sequence_2 = { 488d542470 41b93f000f00 4533c0 48c7c102000080 }
            // n = 4, score = 300
            //   488d542470           | dec                 eax
            //   41b93f000f00         | lea                 eax, [esp + 0x58]
            //   4533c0               | inc                 ecx
            //   48c7c102000080       | mov                 ecx, 4

        $sequence_3 = { 488b4c2460 48897c2440 488d442450 4889442438 }
            // n = 4, score = 300
            //   488b4c2460           | xor                 eax, eax
            //   48897c2440           | dec                 eax
            //   488d442450           | mov                 edx, ebx
            //   4889442438           | dec                 eax

        $sequence_4 = { 4533c9 4533c0 4889442420 ff15???????? 85c0 7537 }
            // n = 6, score = 300
            //   4533c9               | inc                 ebp
            //   4533c0               | xor                 eax, eax
            //   4889442420           | dec                 eax
            //   ff15????????         |                     
            //   85c0                 | mov                 edx, ebx
            //   7537                 | dec                 eax

        $sequence_5 = { 85c0 7534 488b4c2450 488d442458 41b904000000 4533c0 488bd3 }
            // n = 7, score = 300
            //   85c0                 | test                eax, eax
            //   7534                 | jne                 0xfb
            //   488b4c2450           | dec                 eax
            //   488d442458           | mov                 ecx, dword ptr [esp + 0x60]
            //   41b904000000         | dec                 eax
            //   4533c0               | mov                 dword ptr [esp + 0x38], eax
            //   488bd3               | dec                 eax

        $sequence_6 = { 4889442438 48897c2430 4533c0 c74424283f000f00 897c2420 }
            // n = 5, score = 300
            //   4889442438           | mov                 ecx, dword ptr [esp + 0x50]
            //   48897c2430           | dec                 eax
            //   4533c0               | mov                 ecx, 0x80000002
            //   c74424283f000f00     | mov                 dword ptr [esp + 0x28], 0x2001f
            //   897c2420             | mov                 dword ptr [esp + 0x20], ebx

        $sequence_7 = { 48c7c102000080 c74424281f000200 895c2420 ff15???????? 85c0 0f85e7000000 488b4c2460 }
            // n = 7, score = 300
            //   48c7c102000080       | dec                 eax
            //   c74424281f000200     | mov                 edx, ebx
            //   895c2420             | mov                 dword ptr [esp + 0x28], 4
            //   ff15????????         |                     
            //   85c0                 | dec                 eax
            //   0f85e7000000         | mov                 dword ptr [esp + 0x20], eax
            //   488b4c2460           | dec                 eax

        $sequence_8 = { 48895c2440 48895c2458 895c2460 48895c2468 }
            // n = 4, score = 300
            //   48895c2440           | dec                 eax
            //   48895c2458           | mov                 dword ptr [esp + 0x40], ebx
            //   895c2460             | dec                 eax
            //   48895c2468           | mov                 dword ptr [esp + 0x58], ebx

        $sequence_9 = { 75f7 2bc2 8bd0 8d442424 }
            // n = 4, score = 200
            //   75f7                 | jne                 0xfffffff9
            //   2bc2                 | sub                 eax, edx
            //   8bd0                 | mov                 edx, eax
            //   8d442424             | lea                 eax, [esp + 0x24]

        $sequence_10 = { f2ae f7d1 49 52 8d440902 8d8c242c010000 }
            // n = 6, score = 200
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx
            //   49                   | dec                 ecx
            //   52                   | push                edx
            //   8d440902             | lea                 eax, [ecx + ecx + 2]
            //   8d8c242c010000       | lea                 ecx, [esp + 0x12c]

        $sequence_11 = { 68???????? 51 e8???????? 83c40c 53 8d942438050000 52 }
            // n = 7, score = 200
            //   68????????           |                     
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   53                   | push                ebx
            //   8d942438050000       | lea                 edx, [esp + 0x538]
            //   52                   | push                edx

        $sequence_12 = { 51 889c244c050000 e8???????? 83c418 53 }
            // n = 5, score = 200
            //   51                   | push                ecx
            //   889c244c050000       | mov                 byte ptr [esp + 0x54c], bl
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   53                   | push                ebx

        $sequence_13 = { 756f 68dc000000 8d94245c040000 53 }
            // n = 4, score = 200
            //   756f                 | jne                 0x71
            //   68dc000000           | push                0xdc
            //   8d94245c040000       | lea                 edx, [esp + 0x45c]
            //   53                   | push                ebx

        $sequence_14 = { 68???????? 52 c744243804000000 ff15???????? 85c0 }
            // n = 5, score = 200
            //   68????????           |                     
            //   52                   | push                edx
            //   c744243804000000     | mov                 dword ptr [esp + 0x38], 4
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_15 = { 50 e8???????? 8b35???????? 83c438 6a00 8d8c240c010000 51 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b35????????         |                     
            //   83c438               | add                 esp, 0x38
            //   6a00                 | push                0
            //   8d8c240c010000       | lea                 ecx, [esp + 0x10c]
            //   51                   | push                ecx

        $sequence_16 = { 7405 80443420e0 46 3bf7 0f82eafdffff }
            // n = 5, score = 200
            //   7405                 | je                  7
            //   80443420e0           | add                 byte ptr [esp + esi + 0x20], 0xe0
            //   46                   | inc                 esi
            //   3bf7                 | cmp                 esi, edi
            //   0f82eafdffff         | jb                  0xfffffdf0

        $sequence_17 = { 52 6a04 53 68???????? 50 895c242c ffd5 }
            // n = 7, score = 200
            //   52                   | push                edx
            //   6a04                 | push                4
            //   53                   | push                ebx
            //   68????????           |                     
            //   50                   | push                eax
            //   895c242c             | mov                 dword ptr [esp + 0x2c], ebx
            //   ffd5                 | call                ebp

        $sequence_18 = { 3c5a 7708 0420 8bcb 88443420 33c0 8a443420 }
            // n = 7, score = 200
            //   3c5a                 | cmp                 al, 0x5a
            //   7708                 | ja                  0xa
            //   0420                 | add                 al, 0x20
            //   8bcb                 | mov                 ecx, ebx
            //   88443420             | mov                 byte ptr [esp + esi + 0x20], al
            //   33c0                 | xor                 eax, eax
            //   8a443420             | mov                 al, byte ptr [esp + esi + 0x20]

        $sequence_19 = { c684342406000063 e9???????? c68434240600006c e9???????? }
            // n = 4, score = 200
            //   c684342406000063     | mov                 byte ptr [esp + esi + 0x624], 0x63
            //   e9????????           |                     
            //   c68434240600006c     | mov                 byte ptr [esp + esi + 0x624], 0x6c
            //   e9????????           |                     

        $sequence_20 = { ff249560424000 c68434140200006d e9???????? c684341402000071 }
            // n = 4, score = 200
            //   ff249560424000       | jmp                 dword ptr [edx*4 + 0x404260]
            //   c68434140200006d     | mov                 byte ptr [esp + esi + 0x214], 0x6d
            //   e9????????           |                     
            //   c684341402000071     | mov                 byte ptr [esp + esi + 0x214], 0x71

        $sequence_21 = { e9???????? c644341465 e9???????? c644341475 }
            // n = 4, score = 200
            //   e9????????           |                     
            //   c644341465           | mov                 byte ptr [esp + esi + 0x14], 0x65
            //   e9????????           |                     
            //   c644341475           | mov                 byte ptr [esp + esi + 0x14], 0x75

        $sequence_22 = { ff15???????? 85c0 7529 8b4c2410 }
            // n = 4, score = 200
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7529                 | jne                 0x2b
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]

    condition:
        7 of them and filesize < 278528
}