rule win_greetingghoul_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.greetingghoul."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.greetingghoul"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7405 80fa09 7503 47 ebec 8d4ad0 80f909 }
            // n = 7, score = 200
            //   7405                 | je                  7
            //   80fa09               | cmp                 dl, 9
            //   7503                 | jne                 5
            //   47                   | inc                 edi
            //   ebec                 | jmp                 0xffffffee
            //   8d4ad0               | lea                 ecx, [edx - 0x30]
            //   80f909               | cmp                 cl, 9

        $sequence_1 = { 03f1 eb03 83ceff 8a17 84d2 }
            // n = 5, score = 200
            //   03f1                 | add                 esi, ecx
            //   eb03                 | jmp                 5
            //   83ceff               | or                  esi, 0xffffffff
            //   8a17                 | mov                 dl, byte ptr [edi]
            //   84d2                 | test                dl, dl

        $sequence_2 = { 2bc8 7409 8b7df8 4e 43 }
            // n = 5, score = 200
            //   2bc8                 | sub                 ecx, eax
            //   7409                 | je                  0xb
            //   8b7df8               | mov                 edi, dword ptr [ebp - 8]
            //   4e                   | dec                 esi
            //   43                   | inc                 ebx

        $sequence_3 = { 6a01 e8???????? 83c404 85c0 7e02 ff06 }
            // n = 6, score = 200
            //   6a01                 | push                1
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   85c0                 | test                eax, eax
            //   7e02                 | jle                 4
            //   ff06                 | inc                 dword ptr [esi]

        $sequence_4 = { eba7 5f 5e 83c8ff 5b }
            // n = 5, score = 200
            //   eba7                 | jmp                 0xffffffa9
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   83c8ff               | or                  eax, 0xffffffff
            //   5b                   | pop                 ebx

        $sequence_5 = { 750a 83c002 66833c0200 75e8 66833800 }
            // n = 5, score = 200
            //   750a                 | jne                 0xc
            //   83c002               | add                 eax, 2
            //   66833c0200           | cmp                 word ptr [edx + eax], 0
            //   75e8                 | jne                 0xffffffea
            //   66833800             | cmp                 word ptr [eax], 0

        $sequence_6 = { 741b 83ea01 75e8 eb14 0fbe45ff }
            // n = 5, score = 200
            //   741b                 | je                  0x1d
            //   83ea01               | sub                 edx, 1
            //   75e8                 | jne                 0xffffffea
            //   eb14                 | jmp                 0x16
            //   0fbe45ff             | movsx               eax, byte ptr [ebp - 1]

        $sequence_7 = { bb10000000 eb3c 80f909 7708 0fbec2 }
            // n = 5, score = 200
            //   bb10000000           | mov                 ebx, 0x10
            //   eb3c                 | jmp                 0x3e
            //   80f909               | cmp                 cl, 9
            //   7708                 | ja                  0xa
            //   0fbec2               | movsx               eax, dl

        $sequence_8 = { 85c0 7405 83f8ff 7508 85ff }
            // n = 5, score = 200
            //   85c0                 | test                eax, eax
            //   7405                 | je                  7
            //   83f8ff               | cmp                 eax, -1
            //   7508                 | jne                 0xa
            //   85ff                 | test                edi, edi

        $sequence_9 = { 8a08 3acb 750c 40 84c9 }
            // n = 5, score = 200
            //   8a08                 | mov                 cl, byte ptr [eax]
            //   3acb                 | cmp                 cl, bl
            //   750c                 | jne                 0xe
            //   40                   | inc                 eax
            //   84c9                 | test                cl, cl

    condition:
        7 of them and filesize < 696320
}