rule win_h1n1_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.h1n1."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.h1n1"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7513 83bdecfeffff01 750a bb06000000 e9???????? 83bde8feffff06 }
            // n = 6, score = 400
            //   7513                 | jne                 0x15
            //   83bdecfeffff01       | cmp                 dword ptr [ebp - 0x114], 1
            //   750a                 | jne                 0xc
            //   bb06000000           | mov                 ebx, 6
            //   e9????????           |                     
            //   83bde8feffff06       | cmp                 dword ptr [ebp - 0x118], 6

        $sequence_1 = { c7459044000000 8d4580 8d4d90 50 51 6a00 }
            // n = 6, score = 400
            //   c7459044000000       | mov                 dword ptr [ebp - 0x70], 0x44
            //   8d4580               | lea                 eax, [ebp - 0x80]
            //   8d4d90               | lea                 ecx, [ebp - 0x70]
            //   50                   | push                eax
            //   51                   | push                ecx
            //   6a00                 | push                0

        $sequence_2 = { 807dfe01 0f85d0000000 83bde8feffff05 750f 83bdecfeffff00 }
            // n = 5, score = 400
            //   807dfe01             | cmp                 byte ptr [ebp - 2], 1
            //   0f85d0000000         | jne                 0xd6
            //   83bde8feffff05       | cmp                 dword ptr [ebp - 0x118], 5
            //   750f                 | jne                 0x11
            //   83bdecfeffff00       | cmp                 dword ptr [ebp - 0x114], 0

        $sequence_3 = { 0bc0 0f84da010000 fc 8b7508 8b7df4 8b4b54 }
            // n = 6, score = 400
            //   0bc0                 | or                  eax, eax
            //   0f84da010000         | je                  0x1e0
            //   fc                   | cld                 
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   8b7df4               | mov                 edi, dword ptr [ebp - 0xc]
            //   8b4b54               | mov                 ecx, dword ptr [ebx + 0x54]

        $sequence_4 = { 83bde8feffff06 7510 83bdecfeffff00 7507 bb05000000 eb17 }
            // n = 6, score = 400
            //   83bde8feffff06       | cmp                 dword ptr [ebp - 0x118], 6
            //   7510                 | jne                 0x12
            //   83bdecfeffff00       | cmp                 dword ptr [ebp - 0x114], 0
            //   7507                 | jne                 9
            //   bb05000000           | mov                 ebx, 5
            //   eb17                 | jmp                 0x19

        $sequence_5 = { c745ac01000000 c745b010000000 c745b402000000 c745b820000000 }
            // n = 4, score = 400
            //   c745ac01000000       | mov                 dword ptr [ebp - 0x54], 1
            //   c745b010000000       | mov                 dword ptr [ebp - 0x50], 0x10
            //   c745b402000000       | mov                 dword ptr [ebp - 0x4c], 2
            //   c745b820000000       | mov                 dword ptr [ebp - 0x48], 0x20

        $sequence_6 = { 50 ff75fc 6801000080 ff35???????? 58 ffd0 0bc0 }
            // n = 7, score = 400
            //   50                   | push                eax
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   6801000080           | push                0x80000001
            //   ff35????????         |                     
            //   58                   | pop                 eax
            //   ffd0                 | call                eax
            //   0bc0                 | or                  eax, eax

        $sequence_7 = { ab 05befa383a ab 352e1c3a58 ab ff75fc }
            // n = 6, score = 400
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   05befa383a           | add                 eax, 0x3a38fabe
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   352e1c3a58           | xor                 eax, 0x583a1c2e
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   ff75fc               | push                dword ptr [ebp - 4]

        $sequence_8 = { ff15???????? 8bf0 85f6 745d 688c6e0010 56 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi
            //   745d                 | je                  0x5f
            //   688c6e0010           | push                0x10006e8c
            //   56                   | push                esi

        $sequence_9 = { c1e908 330c85908f0010 42 3b54240c 72e4 f7d1 8bc1 }
            // n = 7, score = 100
            //   c1e908               | shr                 ecx, 8
            //   330c85908f0010       | xor                 ecx, dword ptr [eax*4 + 0x10008f90]
            //   42                   | inc                 edx
            //   3b54240c             | cmp                 edx, dword ptr [esp + 0xc]
            //   72e4                 | jb                  0xffffffe6
            //   f7d1                 | not                 ecx
            //   8bc1                 | mov                 eax, ecx

        $sequence_10 = { 59 59 c3 56 8b742408 6804010000 68f8820010 }
            // n = 7, score = 100
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   c3                   | ret                 
            //   56                   | push                esi
            //   8b742408             | mov                 esi, dword ptr [esp + 8]
            //   6804010000           | push                0x104
            //   68f8820010           | push                0x100082f8

        $sequence_11 = { 7620 8b742408 0fb60432 33c1 25ff000000 c1e908 330c85908f0010 }
            // n = 7, score = 100
            //   7620                 | jbe                 0x22
            //   8b742408             | mov                 esi, dword ptr [esp + 8]
            //   0fb60432             | movzx               eax, byte ptr [edx + esi]
            //   33c1                 | xor                 eax, ecx
            //   25ff000000           | and                 eax, 0xff
            //   c1e908               | shr                 ecx, 8
            //   330c85908f0010       | xor                 ecx, dword ptr [eax*4 + 0x10008f90]

        $sequence_12 = { ff74242c b9686e0010 68546e0010 ff742430 b8606e0010 0f44c1 }
            // n = 6, score = 100
            //   ff74242c             | push                dword ptr [esp + 0x2c]
            //   b9686e0010           | mov                 ecx, 0x10006e68
            //   68546e0010           | push                0x10006e54
            //   ff742430             | push                dword ptr [esp + 0x30]
            //   b8606e0010           | mov                 eax, 0x10006e60
            //   0f44c1               | cmove               eax, ecx

        $sequence_13 = { 8b442404 33d2 a3???????? 42 b9c0850010 }
            // n = 5, score = 100
            //   8b442404             | mov                 eax, dword ptr [esp + 4]
            //   33d2                 | xor                 edx, edx
            //   a3????????           |                     
            //   42                   | inc                 edx
            //   b9c0850010           | mov                 ecx, 0x100085c0

        $sequence_14 = { 8d8578fdffff 50 68fc600010 6804010000 }
            // n = 4, score = 100
            //   8d8578fdffff         | lea                 eax, [ebp - 0x288]
            //   50                   | push                eax
            //   68fc600010           | push                0x100060fc
            //   6804010000           | push                0x104

        $sequence_15 = { 8d85f0fdffff 68dc600010 6804010000 50 e8???????? 83c414 8d45fc }
            // n = 7, score = 100
            //   8d85f0fdffff         | lea                 eax, [ebp - 0x210]
            //   68dc600010           | push                0x100060dc
            //   6804010000           | push                0x104
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   8d45fc               | lea                 eax, [ebp - 4]

    condition:
        7 of them and filesize < 172032
}