rule win_hardrain_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.hardrain."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hardrain"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33f6 57 85db 8bf9 763f 8b6c2414 68b4000000 }
            // n = 7, score = 200
            //   33f6                 | xor                 esi, esi
            //   57                   | push                edi
            //   85db                 | test                ebx, ebx
            //   8bf9                 | mov                 edi, ecx
            //   763f                 | jbe                 0x41
            //   8b6c2414             | mov                 ebp, dword ptr [esp + 0x14]
            //   68b4000000           | push                0xb4

        $sequence_1 = { 8bf1 7431 803802 752c 8a4826 83c026 80f920 }
            // n = 7, score = 200
            //   8bf1                 | mov                 esi, ecx
            //   7431                 | je                  0x33
            //   803802               | cmp                 byte ptr [eax], 2
            //   752c                 | jne                 0x2e
            //   8a4826               | mov                 cl, byte ptr [eax + 0x26]
            //   83c026               | add                 eax, 0x26
            //   80f920               | cmp                 cl, 0x20

        $sequence_2 = { 0f85a4000000 50 50 50 56 ff15???????? }
            // n = 6, score = 200
            //   0f85a4000000         | jne                 0xaa
            //   50                   | push                eax
            //   50                   | push                eax
            //   50                   | push                eax
            //   56                   | push                esi
            //   ff15????????         |                     

        $sequence_3 = { 743a 6a16 8d4c241c 55 }
            // n = 4, score = 200
            //   743a                 | je                  0x3c
            //   6a16                 | push                0x16
            //   8d4c241c             | lea                 ecx, [esp + 0x1c]
            //   55                   | push                ebp

        $sequence_4 = { 50 6a00 6a00 51 53 89742430 c744242c01000000 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   51                   | push                ecx
            //   53                   | push                ebx
            //   89742430             | mov                 dword ptr [esp + 0x30], esi
            //   c744242c01000000     | mov                 dword ptr [esp + 0x2c], 1

        $sequence_5 = { 6a0c 52 56 89442418 894c2414 }
            // n = 5, score = 200
            //   6a0c                 | push                0xc
            //   52                   | push                edx
            //   56                   | push                esi
            //   89442418             | mov                 dword ptr [esp + 0x18], eax
            //   894c2414             | mov                 dword ptr [esp + 0x14], ecx

        $sequence_6 = { 68???????? 56 e8???????? 83c414 85c0 75de 68b4000000 }
            // n = 7, score = 200
            //   68????????           |                     
            //   56                   | push                esi
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   85c0                 | test                eax, eax
            //   75de                 | jne                 0xffffffe0
            //   68b4000000           | push                0xb4

        $sequence_7 = { 6aff 51 ff15???????? 33c0 81c4540c0000 }
            // n = 5, score = 200
            //   6aff                 | push                -1
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   33c0                 | xor                 eax, eax
            //   81c4540c0000         | add                 esp, 0xc54

        $sequence_8 = { 5d b801000000 5b 59 c20400 8b4c2410 895910 }
            // n = 7, score = 200
            //   5d                   | pop                 ebp
            //   b801000000           | mov                 eax, 1
            //   5b                   | pop                 ebx
            //   59                   | pop                 ecx
            //   c20400               | ret                 4
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]
            //   895910               | mov                 dword ptr [ecx + 0x10], ebx

        $sequence_9 = { ff15???????? 8bf0 83feff 0f8493000000 8d442408 }
            // n = 5, score = 200
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   83feff               | cmp                 esi, -1
            //   0f8493000000         | je                  0x99
            //   8d442408             | lea                 eax, [esp + 8]

    condition:
        7 of them and filesize < 368640
}