rule win_hemigate_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.hemigate."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hemigate"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { f7db 895dd4 663bca 0f83b6000000 eb10 663bc8 0f86ab000000 }
            // n = 7, score = 200
            //   f7db                 | neg                 ebx
            //   895dd4               | mov                 dword ptr [ebp - 0x2c], ebx
            //   663bca               | cmp                 cx, dx
            //   0f83b6000000         | jae                 0xbc
            //   eb10                 | jmp                 0x12
            //   663bc8               | cmp                 cx, ax
            //   0f86ab000000         | jbe                 0xb1

        $sequence_1 = { 8bfa 0fb64610 8b5610 8845dc 8bc2 c1e808 8845dd }
            // n = 7, score = 200
            //   8bfa                 | mov                 edi, edx
            //   0fb64610             | movzx               eax, byte ptr [esi + 0x10]
            //   8b5610               | mov                 edx, dword ptr [esi + 0x10]
            //   8845dc               | mov                 byte ptr [ebp - 0x24], al
            //   8bc2                 | mov                 eax, edx
            //   c1e808               | shr                 eax, 8
            //   8845dd               | mov                 byte ptr [ebp - 0x23], al

        $sequence_2 = { e8???????? 6a3c 8bf0 6a00 56 89b5f4feffff e8???????? }
            // n = 7, score = 200
            //   e8????????           |                     
            //   6a3c                 | push                0x3c
            //   8bf0                 | mov                 esi, eax
            //   6a00                 | push                0
            //   56                   | push                esi
            //   89b5f4feffff         | mov                 dword ptr [ebp - 0x10c], esi
            //   e8????????           |                     

        $sequence_3 = { 8d4bfe c6460200 8d5901 eb04 85db 7411 8bc2 }
            // n = 7, score = 200
            //   8d4bfe               | lea                 ecx, [ebx - 2]
            //   c6460200             | mov                 byte ptr [esi + 2], 0
            //   8d5901               | lea                 ebx, [ecx + 1]
            //   eb04                 | jmp                 6
            //   85db                 | test                ebx, ebx
            //   7411                 | je                  0x13
            //   8bc2                 | mov                 eax, edx

        $sequence_4 = { e8???????? eb0b 6a01 50 51 8bcf e8???????? }
            // n = 7, score = 200
            //   e8????????           |                     
            //   eb0b                 | jmp                 0xd
            //   6a01                 | push                1
            //   50                   | push                eax
            //   51                   | push                ecx
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     

        $sequence_5 = { ff37 e8???????? 57 e8???????? 83c414 6a00 ff75f8 }
            // n = 7, score = 200
            //   ff37                 | push                dword ptr [edi]
            //   e8????????           |                     
            //   57                   | push                edi
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   6a00                 | push                0
            //   ff75f8               | push                dword ptr [ebp - 8]

        $sequence_6 = { 0f8cae020000 0fb6140f 0fb6440f01 c1e208 03d0 0fb6440f02 c1e208 }
            // n = 7, score = 200
            //   0f8cae020000         | jl                  0x2b4
            //   0fb6140f             | movzx               edx, byte ptr [edi + ecx]
            //   0fb6440f01           | movzx               eax, byte ptr [edi + ecx + 1]
            //   c1e208               | shl                 edx, 8
            //   03d0                 | add                 edx, eax
            //   0fb6440f02           | movzx               eax, byte ptr [edi + ecx + 2]
            //   c1e208               | shl                 edx, 8

        $sequence_7 = { 8945f4 8bc6 85c0 0f84dd000000 90 48 83f80e }
            // n = 7, score = 200
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   8bc6                 | mov                 eax, esi
            //   85c0                 | test                eax, eax
            //   0f84dd000000         | je                  0xe3
            //   90                   | nop                 
            //   48                   | dec                 eax
            //   83f80e               | cmp                 eax, 0xe

        $sequence_8 = { 741a 8d45f4 50 6a04 ff75f8 ff15???????? 6a00 }
            // n = 7, score = 200
            //   741a                 | je                  0x1c
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   50                   | push                eax
            //   6a04                 | push                4
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   ff15????????         |                     
            //   6a00                 | push                0

        $sequence_9 = { c3 ff75f8 ff15???????? 83c404 5f 5e b80d000000 }
            // n = 7, score = 200
            //   c3                   | ret                 
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   ff15????????         |                     
            //   83c404               | add                 esp, 4
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   b80d000000           | mov                 eax, 0xd

    condition:
        7 of them and filesize < 991232
}