rule win_holerun_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.holerun."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.holerun"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488d05df640000 890c02 488345f801 48837df81f }
            // n = 4, score = 100
            //   488d05df640000       | mov                 eax, dword ptr [eax + 0x10]
            //   890c02               | dec                 eax
            //   488345f801           | mov                 dword ptr [ebp - 0x10], eax
            //   48837df81f           | dec                 eax

        $sequence_1 = { 488b05???????? ffd0 c785a8fdffff38000000 31c0 8985acfdffff 488985b0fdffff 488985b8fdffff }
            // n = 7, score = 100
            //   488b05????????       |                     
            //   ffd0                 | sub                 esp, 0x50
            //   c785a8fdffff38000000     | mov    dword ptr [ebp + 0x10], ecx
            //   31c0                 | dec                 eax
            //   8985acfdffff         | mov                 dword ptr [ebp + 0x18], edx
            //   488985b0fdffff       | movsd               qword ptr [ebp + 0x20], xmm2
            //   488985b8fdffff       | movsd               qword ptr [ebp + 0x28], xmm3

        $sequence_2 = { 488b05???????? 8b00 83f801 7520 488b15???????? }
            // n = 5, score = 100
            //   488b05????????       |                     
            //   8b00                 | sub                 esp, 0x70
            //   83f801               | mov                 dword ptr [ebp - 4], 0
            //   7520                 | mov                 eax, dword ptr [ebp - 4]
            //   488b15????????       |                     

        $sequence_3 = { 4883c420 5d c3 55 4889e5 4883ec40 894d10 }
            // n = 7, score = 100
            //   4883c420             | dec                 eax
            //   5d                   | add                 eax, ecx
            //   c3                   | dec                 eax
            //   55                   | mov                 edx, dword ptr [eax + 8]
            //   4889e5               | dec                 eax
            //   4883ec40             | mov                 eax, dword ptr [ebp - 0x30]
            //   894d10               | mov                 eax, dword ptr [eax + 8]

        $sequence_4 = { 488b45f8 4801d0 488945f0 488b45f0 8b00 3d50450000 740a }
            // n = 7, score = 100
            //   488b45f8             | mov                 dword ptr [ebp + 0xa0], eax
            //   4801d0               | mov                 dword ptr [ebp + 0x2cc], 0
            //   488945f0             | mov                 eax, dword ptr [ebp + 0x2cc]
            //   488b45f0             | dec                 eax
            //   8b00                 | cwde                
            //   3d50450000           | dec                 eax
            //   740a                 | mov                 eax, dword ptr [ebp + eax*8 + 0x90]

        $sequence_5 = { 4801c8 4889c1 488b55b8 488b45a0 4989c9 41b840000000 4889c1 }
            // n = 7, score = 100
            //   4801c8               | dec                 eax
            //   4889c1               | mov                 dword ptr [ebp - 0x38], eax
            //   488b55b8             | jmp                 0x10ba
            //   488b45a0             | dec                 eax
            //   4989c9               | lea                 eax, [0x38be]
            //   41b840000000         | dec                 eax
            //   4889c1               | mov                 dword ptr [ebp - 0x38], eax

        $sequence_6 = { c744242000000000 41b902000000 4989c8 4889c1 488b05???????? }
            // n = 5, score = 100
            //   c744242000000000     | dec                 eax
            //   41b902000000         | cwde                
            //   4989c8               | dec                 eax
            //   4889c1               | mov                 eax, dword ptr [ebp + eax*8 + 0x90]
            //   488b05????????       |                     

        $sequence_7 = { 4889c2 8b4d10 e8???????? 8945fc }
            // n = 4, score = 100
            //   4889c2               | mov                 dword ptr [ebp + 0x18], edx
            //   8b4d10               | dec                 esp
            //   e8????????           |                     
            //   8945fc               | mov                 dword ptr [ebp + 0x20], eax

        $sequence_8 = { 488b45f0 4883c018 488945e8 488b45e8 }
            // n = 4, score = 100
            //   488b45f0             | dec                 eax
            //   4883c018             | mov                 eax, dword ptr [eax]
            //   488945e8             | dec                 eax
            //   488b45e8             | mov                 eax, dword ptr [eax + 0x20]

        $sequence_9 = { 488d15c1400000 4889c1 e8???????? e9???????? }
            // n = 4, score = 100
            //   488d15c1400000       | dec                 eax
            //   4889c1               | lea                 edx, [0x4099]
            //   e8????????           |                     
            //   e9????????           |                     

    condition:
        7 of them and filesize < 156672
}