rule win_htprat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.htprat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.htprat"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 85c0 0f8404020000 8b954cefffff 33f6 3bd6 0f84e1000000 }
            // n = 7, score = 200
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f8404020000         | je                  0x20a
            //   8b954cefffff         | mov                 edx, dword ptr [ebp - 0x10b4]
            //   33f6                 | xor                 esi, esi
            //   3bd6                 | cmp                 edx, esi
            //   0f84e1000000         | je                  0xe7

        $sequence_1 = { e8???????? 8b45d0 3b45c0 75e0 e9???????? 83f95b }
            // n = 6, score = 200
            //   e8????????           |                     
            //   8b45d0               | mov                 eax, dword ptr [ebp - 0x30]
            //   3b45c0               | cmp                 eax, dword ptr [ebp - 0x40]
            //   75e0                 | jne                 0xffffffe2
            //   e9????????           |                     
            //   83f95b               | cmp                 ecx, 0x5b

        $sequence_2 = { 85c0 0f849a000000 8b8568efffff 03c6 3b8558efffff 7667 8b8394000000 }
            // n = 7, score = 200
            //   85c0                 | test                eax, eax
            //   0f849a000000         | je                  0xa0
            //   8b8568efffff         | mov                 eax, dword ptr [ebp - 0x1098]
            //   03c6                 | add                 eax, esi
            //   3b8558efffff         | cmp                 eax, dword ptr [ebp - 0x10a8]
            //   7667                 | jbe                 0x69
            //   8b8394000000         | mov                 eax, dword ptr [ebx + 0x94]

        $sequence_3 = { 897d98 56 33ff 47 }
            // n = 4, score = 200
            //   897d98               | mov                 dword ptr [ebp - 0x68], edi
            //   56                   | push                esi
            //   33ff                 | xor                 edi, edi
            //   47                   | inc                 edi

        $sequence_4 = { 668b5508 66891448 837e1408 895e10 7204 8b06 eb02 }
            // n = 7, score = 200
            //   668b5508             | mov                 dx, word ptr [ebp + 8]
            //   66891448             | mov                 word ptr [eax + ecx*2], dx
            //   837e1408             | cmp                 dword ptr [esi + 0x14], 8
            //   895e10               | mov                 dword ptr [esi + 0x10], ebx
            //   7204                 | jb                  6
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   eb02                 | jmp                 4

        $sequence_5 = { 8d4dd4 51 50 e8???????? eb02 33c0 }
            // n = 6, score = 200
            //   8d4dd4               | lea                 ecx, [ebp - 0x2c]
            //   51                   | push                ecx
            //   50                   | push                eax
            //   e8????????           |                     
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax

        $sequence_6 = { b8???????? e8???????? 8b7508 33db 895de8 c746140f000000 895e10 }
            // n = 7, score = 200
            //   b8????????           |                     
            //   e8????????           |                     
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   33db                 | xor                 ebx, ebx
            //   895de8               | mov                 dword ptr [ebp - 0x18], ebx
            //   c746140f000000       | mov                 dword ptr [esi + 0x14], 0xf
            //   895e10               | mov                 dword ptr [esi + 0x10], ebx

        $sequence_7 = { 84c0 7422 8d45fc 50 e8???????? 8bf0 59 }
            // n = 7, score = 200
            //   84c0                 | test                al, al
            //   7422                 | je                  0x24
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   59                   | pop                 ecx

        $sequence_8 = { 75ec ebb5 8b75bc eb0f }
            // n = 4, score = 200
            //   75ec                 | jne                 0xffffffee
            //   ebb5                 | jmp                 0xffffffb7
            //   8b75bc               | mov                 esi, dword ptr [ebp - 0x44]
            //   eb0f                 | jmp                 0x11

        $sequence_9 = { e8???????? 84c0 742c 837e1408 8b4e10 7204 }
            // n = 6, score = 200
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   742c                 | je                  0x2e
            //   837e1408             | cmp                 dword ptr [esi + 0x14], 8
            //   8b4e10               | mov                 ecx, dword ptr [esi + 0x10]
            //   7204                 | jb                  6

    condition:
        7 of them and filesize < 278528
}