rule win_htran_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.htran."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.htran"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a00 2bd5 8d8424f0520000 52 50 }
            // n = 5, score = 200
            //   6a00                 | push                0
            //   2bd5                 | sub                 edx, ebp
            //   8d8424f0520000       | lea                 eax, [esp + 0x52f0]
            //   52                   | push                edx
            //   50                   | push                eax

        $sequence_1 = { 3b1d???????? 0f8315010000 8bc3 8bcb c1f805 83e11f 8b048500c54000 }
            // n = 7, score = 200
            //   3b1d????????         |                     
            //   0f8315010000         | jae                 0x11b
            //   8bc3                 | mov                 eax, ebx
            //   8bcb                 | mov                 ecx, ebx
            //   c1f805               | sar                 eax, 5
            //   83e11f               | and                 ecx, 0x1f
            //   8b048500c54000       | mov                 eax, dword ptr [eax*4 + 0x40c500]

        $sequence_2 = { 8d3449 8d34b5f09b4000 83c00c 3bc6 7304 }
            // n = 5, score = 200
            //   8d3449               | lea                 esi, [ecx + ecx*2]
            //   8d34b5f09b4000       | lea                 esi, [esi*4 + 0x409bf0]
            //   83c00c               | add                 eax, 0xc
            //   3bc6                 | cmp                 eax, esi
            //   7304                 | jae                 6

        $sequence_3 = { 8dbc24eca20000 c1e902 f3a5 8bc8 33c0 }
            // n = 5, score = 200
            //   8dbc24eca20000       | lea                 edi, [esp + 0xa2ec]
            //   c1e902               | shr                 ecx, 2
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   8bc8                 | mov                 ecx, eax
            //   33c0                 | xor                 eax, eax

        $sequence_4 = { 6a01 58 c20400 8b542404 }
            // n = 4, score = 200
            //   6a01                 | push                1
            //   58                   | pop                 eax
            //   c20400               | ret                 4
            //   8b542404             | mov                 edx, dword ptr [esp + 4]

        $sequence_5 = { 85ff 7faf e9???????? 85ed 0f8e74feffff 85f6 0f8e6cfeffff }
            // n = 7, score = 200
            //   85ff                 | test                edi, edi
            //   7faf                 | jg                  0xffffffb1
            //   e9????????           |                     
            //   85ed                 | test                ebp, ebp
            //   0f8e74feffff         | jle                 0xfffffe7a
            //   85f6                 | test                esi, esi
            //   0f8e6cfeffff         | jle                 0xfffffe72

        $sequence_6 = { 8816 46 eb0f 0fb6d2 f682c1c3400004 }
            // n = 5, score = 200
            //   8816                 | mov                 byte ptr [esi], dl
            //   46                   | inc                 esi
            //   eb0f                 | jmp                 0x11
            //   0fb6d2               | movzx               edx, dl
            //   f682c1c3400004       | test                byte ptr [edx + 0x40c3c1], 4

        $sequence_7 = { e9???????? 68???????? e8???????? 8b942430510000 55 52 }
            // n = 6, score = 200
            //   e9????????           |                     
            //   68????????           |                     
            //   e8????????           |                     
            //   8b942430510000       | mov                 edx, dword ptr [esp + 0x5130]
            //   55                   | push                ebp
            //   52                   | push                edx

        $sequence_8 = { 33c0 8dbc24ec520000 f3ab 8d9424e4000000 52 53 }
            // n = 6, score = 200
            //   33c0                 | xor                 eax, eax
            //   8dbc24ec520000       | lea                 edi, [esp + 0x52ec]
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   8d9424e4000000       | lea                 edx, [esp + 0xe4]
            //   52                   | push                edx
            //   53                   | push                ebx

        $sequence_9 = { 899424e8010000 89b424e8000000 899424e4000000 33c0 8d8c24e8000000 }
            // n = 5, score = 200
            //   899424e8010000       | mov                 dword ptr [esp + 0x1e8], edx
            //   89b424e8000000       | mov                 dword ptr [esp + 0xe8], esi
            //   899424e4000000       | mov                 dword ptr [esp + 0xe4], edx
            //   33c0                 | xor                 eax, eax
            //   8d8c24e8000000       | lea                 ecx, [esp + 0xe8]

    condition:
        7 of them and filesize < 114688
}