rule win_hyperbro_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.hyperbro."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hyperbro"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c404 6882000000 6a00 50 8903 e8???????? }
            // n = 6, score = 400
            //   83c404               | add                 esp, 4
            //   6882000000           | push                0x82
            //   6a00                 | push                0
            //   50                   | push                eax
            //   8903                 | mov                 dword ptr [ebx], eax
            //   e8????????           |                     

        $sequence_1 = { d1f8 8d3410 83fe40 7f37 8bc3 8bd3 }
            // n = 6, score = 400
            //   d1f8                 | sar                 eax, 1
            //   8d3410               | lea                 esi, [eax + edx]
            //   83fe40               | cmp                 esi, 0x40
            //   7f37                 | jg                  0x39
            //   8bc3                 | mov                 eax, ebx
            //   8bd3                 | mov                 edx, ebx

        $sequence_2 = { 52 6a01 8d4c2414 51 50 c744241800000000 ff15???????? }
            // n = 7, score = 400
            //   52                   | push                edx
            //   6a01                 | push                1
            //   8d4c2414             | lea                 ecx, [esp + 0x14]
            //   51                   | push                ecx
            //   50                   | push                eax
            //   c744241800000000     | mov                 dword ptr [esp + 0x18], 0
            //   ff15????????         |                     

        $sequence_3 = { 85c0 752f 8b4304 50 }
            // n = 4, score = 400
            //   85c0                 | test                eax, eax
            //   752f                 | jne                 0x31
            //   8b4304               | mov                 eax, dword ptr [ebx + 4]
            //   50                   | push                eax

        $sequence_4 = { 895014 8d442410 50 8d4c2424 51 6a00 }
            // n = 6, score = 400
            //   895014               | mov                 dword ptr [eax + 0x14], edx
            //   8d442410             | lea                 eax, [esp + 0x10]
            //   50                   | push                eax
            //   8d4c2424             | lea                 ecx, [esp + 0x24]
            //   51                   | push                ecx
            //   6a00                 | push                0

        $sequence_5 = { 7412 50 e8???????? 83c404 897e18 897e1c }
            // n = 6, score = 400
            //   7412                 | je                  0x14
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   897e18               | mov                 dword ptr [esi + 0x18], edi
            //   897e1c               | mov                 dword ptr [esi + 0x1c], edi

        $sequence_6 = { 51 ff15???????? 56 ffd5 5f 5e 5d }
            // n = 7, score = 400
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   56                   | push                esi
            //   ffd5                 | call                ebp
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp

        $sequence_7 = { 8bdd 2bde c744243000000000 0f84c2000000 }
            // n = 4, score = 400
            //   8bdd                 | mov                 ebx, ebp
            //   2bde                 | sub                 ebx, esi
            //   c744243000000000     | mov                 dword ptr [esp + 0x30], 0
            //   0f84c2000000         | je                  0xc8

        $sequence_8 = { 3bd6 0f839b020000 8b442420 2bc6 83f803 }
            // n = 5, score = 400
            //   3bd6                 | cmp                 edx, esi
            //   0f839b020000         | jae                 0x2a1
            //   8b442420             | mov                 eax, dword ptr [esp + 0x20]
            //   2bc6                 | sub                 eax, esi
            //   83f803               | cmp                 eax, 3

        $sequence_9 = { e8???????? 8b4724 50 e8???????? 8b4f20 51 e8???????? }
            // n = 7, score = 400
            //   e8????????           |                     
            //   8b4724               | mov                 eax, dword ptr [edi + 0x24]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b4f20               | mov                 ecx, dword ptr [edi + 0x20]
            //   51                   | push                ecx
            //   e8????????           |                     

    condition:
        7 of them and filesize < 352256
}