rule win_iconic_stealer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.iconic_stealer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.iconic_stealer"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 85c0 0f840c020000 4084f6 0f847e030000 45386c2467 0f8573030000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   85c0                 | arpl                word ptr [edi], cx
            //   0f840c020000         | dec                 esp
            //   4084f6               | mov                 esp, esi
            //   0f847e030000         | inc                 esp
            //   45386c2467           | mov                 ebp, dword ptr [esp + 0x78]
            //   0f8573030000         | cmp                 dword ptr [esi], ecx

        $sequence_1 = { f20f590d???????? f20f580d???????? f20f580d???????? 897728 33f6 f2480f2cc1 488907 }
            // n = 7, score = 100
            //   f20f590d????????     |                     
            //   f20f580d????????     |                     
            //   f20f580d????????     |                     
            //   897728               | dec                 eax
            //   33f6                 | inc                 dword ptr [ebp - 0x51]
            //   f2480f2cc1           | dec                 ecx
            //   488907               | mov                 edx, dword ptr [esi + edi*8 + 8]

        $sequence_2 = { ffca 490faf92c8000000 4c8b09 41ff9190000000 eb08 498bcb e8???????? }
            // n = 7, score = 100
            //   ffca                 | xor                 ecx, ecx
            //   490faf92c8000000     | inc                 esp
            //   4c8b09               | mov                 dword ptr [esp + 0x20], edi
            //   41ff9190000000       | inc                 ebp
            //   eb08                 | xor                 eax, eax
            //   498bcb               | dec                 eax
            //   e8????????           |                     

        $sequence_3 = { e8???????? 89442448 eb2e 488d0c52 8d4201 898390000000 488b8388000000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   89442448             | dec                 eax
            //   eb2e                 | mov                 dword ptr [esp + 0x180], edi
            //   488d0c52             | dec                 eax
            //   8d4201               | cmp                 dword ptr [eax + 0x58], ebx
            //   898390000000         | jne                 0xc23
            //   488b8388000000       | dec                 ecx

        $sequence_4 = { e8???????? 498b0c24 488d542430 41b101 41c744242401000000 49c7c0ffffffff 48c7442420ffffffff }
            // n = 7, score = 100
            //   e8????????           |                     
            //   498b0c24             | je                  0x9fe
            //   488d542430           | movzx               eax, word ptr [esi + 0x60]
            //   41b101               | dec                 ebp
            //   41c744242401000000     | mov    edx, ebp
            //   49c7c0ffffffff       | inc                 sp
            //   48c7442420ffffffff     | cmp    ebp, eax

        $sequence_5 = { 7416 41b101 4c897c2420 448bc5 418bd4 488bcf e8???????? }
            // n = 7, score = 100
            //   7416                 | dec                 eax
            //   41b101               | inc                 esp
            //   4c897c2420           | movsx               esi, cx
            //   448bc5               | inc                 esp
            //   418bd4               | mov                 eax, esi
            //   488bcf               | jmp                 0x528
            //   e8????????           |                     

        $sequence_6 = { f6c224 7405 488b31 eb2b f6c208 740e f20f1001 }
            // n = 7, score = 100
            //   f6c224               | mov                 edx, dword ptr [ebx + 8]
            //   7405                 | inc                 esp
            //   488b31               | movzx               ecx, ch
            //   eb2b                 | test                esi, esi
            //   f6c208               | je                  0xbb1
            //   740e                 | cmp                 byte ptr [ebx + 0x20], 0
            //   f20f1001             | dec                 eax

        $sequence_7 = { ffc3 4903ee 413bdf 0f8e5dffffff 488b5c2448 4885db 0f8495000000 }
            // n = 7, score = 100
            //   ffc3                 | cmp                 al, 2
            //   4903ee               | jne                 0xd96
            //   413bdf               | dec                 eax
            //   0f8e5dffffff         | mov                 ebp, dword ptr [ebp + 0x28]
            //   488b5c2448           | dec                 eax
            //   4885db               | mov                 eax, ebp
            //   0f8495000000         | dec                 eax

        $sequence_8 = { eb1e 486306 8d4801 394e04 0f8d94000000 488b4d00 4d8bc6 }
            // n = 7, score = 100
            //   eb1e                 | mov                 eax, dword ptr [esi + 0x20]
            //   486306               | dec                 esp
            //   8d4801               | mov                 ecx, dword ptr [eax + 8]
            //   394e04               | inc                 ecx
            //   0f8d94000000         | movzx               eax, byte ptr [ecx]
            //   488b4d00             | cmp                 al, 0xa7
            //   4d8bc6               | jne                 0x48b

        $sequence_9 = { 7d0f 488b4208 488d0c49 0fb654c80c eb02 b244 0fbeda }
            // n = 7, score = 100
            //   7d0f                 | inc                 esp
            //   488b4208             | mov                 eax, dword ptr [ebx + 0xa4]
            //   488d0c49             | mov                 esi, dword ptr [ebx + 0x28]
            //   0fb654c80c           | inc                 ecx
            //   eb02                 | lea                 eax, [eax + 2]
            //   b244                 | cmp                 esi, eax
            //   0fbeda               | jl                  0x645

    condition:
        7 of them and filesize < 2401280
}