rule win_iispy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.iispy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.iispy"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { eb05 8b0e 8b7608 51 ff75ec 51 56 }
            // n = 7, score = 100
            //   eb05                 | jmp                 7
            //   8b0e                 | mov                 ecx, dword ptr [esi]
            //   8b7608               | mov                 esi, dword ptr [esi + 8]
            //   51                   | push                ecx
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   51                   | push                ecx
            //   56                   | push                esi

        $sequence_1 = { 894c2408 83f80a 7d10 6a0a 8bce e8???????? 8b4e0c }
            // n = 7, score = 100
            //   894c2408             | mov                 dword ptr [esp + 8], ecx
            //   83f80a               | cmp                 eax, 0xa
            //   7d10                 | jge                 0x12
            //   6a0a                 | push                0xa
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   8b4e0c               | mov                 ecx, dword ptr [esi + 0xc]

        $sequence_2 = { 6808020000 ff5048 8bd8 33f6 85db 7517 }
            // n = 6, score = 100
            //   6808020000           | push                0x208
            //   ff5048               | call                dword ptr [eax + 0x48]
            //   8bd8                 | mov                 ebx, eax
            //   33f6                 | xor                 esi, esi
            //   85db                 | test                ebx, ebx
            //   7517                 | jne                 0x19

        $sequence_3 = { 8b4c2410 8944240c 8b442414 25ffffff7f 89542408 0bc8 }
            // n = 6, score = 100
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]
            //   8944240c             | mov                 dword ptr [esp + 0xc], eax
            //   8b442414             | mov                 eax, dword ptr [esp + 0x14]
            //   25ffffff7f           | and                 eax, 0x7fffffff
            //   89542408             | mov                 dword ptr [esp + 8], edx
            //   0bc8                 | or                  ecx, eax

        $sequence_4 = { 0fb60455c1820210 8803 43 eb05 80c230 }
            // n = 5, score = 100
            //   0fb60455c1820210     | movzx               eax, byte ptr [edx*2 + 0x100282c1]
            //   8803                 | mov                 byte ptr [ebx], al
            //   43                   | inc                 ebx
            //   eb05                 | jmp                 7
            //   80c230               | add                 dl, 0x30

        $sequence_5 = { e8???????? 8b4f0c 8d0431 89470c 85c9 7465 6a00 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b4f0c               | mov                 ecx, dword ptr [edi + 0xc]
            //   8d0431               | lea                 eax, [ecx + esi]
            //   89470c               | mov                 dword ptr [edi + 0xc], eax
            //   85c9                 | test                ecx, ecx
            //   7465                 | je                  0x67
            //   6a00                 | push                0

        $sequence_6 = { 55 8bec 8b4508 53 57 8d1c8500d30210 }
            // n = 6, score = 100
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   53                   | push                ebx
            //   57                   | push                edi
            //   8d1c8500d30210       | lea                 ebx, [eax*4 + 0x1002d300]

        $sequence_7 = { 85c0 8b45b8 7424 8b55e0 b9???????? 81c208020000 0f45ca }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   8b45b8               | mov                 eax, dword ptr [ebp - 0x48]
            //   7424                 | je                  0x26
            //   8b55e0               | mov                 edx, dword ptr [ebp - 0x20]
            //   b9????????           |                     
            //   81c208020000         | add                 edx, 0x208
            //   0f45ca               | cmovne              ecx, edx

        $sequence_8 = { 894c2414 3ad0 7610 49 894c2414 381431 757f }
            // n = 7, score = 100
            //   894c2414             | mov                 dword ptr [esp + 0x14], ecx
            //   3ad0                 | cmp                 dl, al
            //   7610                 | jbe                 0x12
            //   49                   | dec                 ecx
            //   894c2414             | mov                 dword ptr [esp + 0x14], ecx
            //   381431               | cmp                 byte ptr [ecx + esi], dl
            //   757f                 | jne                 0x81

        $sequence_9 = { 743a 56 ff75c4 8d4dc8 e8???????? 8b7de0 85ff }
            // n = 7, score = 100
            //   743a                 | je                  0x3c
            //   56                   | push                esi
            //   ff75c4               | push                dword ptr [ebp - 0x3c]
            //   8d4dc8               | lea                 ecx, [ebp - 0x38]
            //   e8????????           |                     
            //   8b7de0               | mov                 edi, dword ptr [ebp - 0x20]
            //   85ff                 | test                edi, edi

    condition:
        7 of them and filesize < 397312
}