rule win_ironhalo_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.ironhalo."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ironhalo"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bd0 c1f905 83e21f 8b0c8d60e04000 f644d10401 7425 }
            // n = 6, score = 200
            //   8bd0                 | mov                 edx, eax
            //   c1f905               | sar                 ecx, 5
            //   83e21f               | and                 edx, 0x1f
            //   8b0c8d60e04000       | mov                 ecx, dword ptr [ecx*4 + 0x40e060]
            //   f644d10401           | test                byte ptr [ecx + edx*8 + 4], 1
            //   7425                 | je                  0x27

        $sequence_1 = { 52 50 e8???????? 8d0476 83c408 8d0480 }
            // n = 6, score = 200
            //   52                   | push                edx
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d0476               | lea                 eax, [esi + esi*2]
            //   83c408               | add                 esp, 8
            //   8d0480               | lea                 eax, [eax + eax*4]

        $sequence_2 = { 81c420430000 c3 8b8c2438430000 6a00 6800000084 6a00 }
            // n = 6, score = 200
            //   81c420430000         | add                 esp, 0x4320
            //   c3                   | ret                 
            //   8b8c2438430000       | mov                 ecx, dword ptr [esp + 0x4338]
            //   6a00                 | push                0
            //   6800000084           | push                0x84000000
            //   6a00                 | push                0

        $sequence_3 = { eb02 33c0 0fbe84c12c914000 c1f804 }
            // n = 4, score = 200
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax
            //   0fbe84c12c914000     | movsx               eax, byte ptr [ecx + eax*8 + 0x40912c]
            //   c1f804               | sar                 eax, 4

        $sequence_4 = { 83651003 8bf0 750b c1e602 8b86b0c74000 }
            // n = 5, score = 200
            //   83651003             | and                 dword ptr [ebp + 0x10], 3
            //   8bf0                 | mov                 esi, eax
            //   750b                 | jne                 0xd
            //   c1e602               | shl                 esi, 2
            //   8b86b0c74000         | mov                 eax, dword ptr [esi + 0x40c7b0]

        $sequence_5 = { 8d0480 c1e005 50 ffd7 }
            // n = 4, score = 200
            //   8d0480               | lea                 eax, [eax + eax*4]
            //   c1e005               | shl                 eax, 5
            //   50                   | push                eax
            //   ffd7                 | call                edi

        $sequence_6 = { b90a000000 33c0 8d7c2438 885c1410 f3ab }
            // n = 5, score = 200
            //   b90a000000           | mov                 ecx, 0xa
            //   33c0                 | xor                 eax, eax
            //   8d7c2438             | lea                 edi, [esp + 0x38]
            //   885c1410             | mov                 byte ptr [esp + edx + 0x10], bl
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax

        $sequence_7 = { 8bc2 8bf2 c1f805 83e61f 8b048560e04000 8b04f0 83f8ff }
            // n = 7, score = 200
            //   8bc2                 | mov                 eax, edx
            //   8bf2                 | mov                 esi, edx
            //   c1f805               | sar                 eax, 5
            //   83e61f               | and                 esi, 0x1f
            //   8b048560e04000       | mov                 eax, dword ptr [eax*4 + 0x40e060]
            //   8b04f0               | mov                 eax, dword ptr [eax + esi*8]
            //   83f8ff               | cmp                 eax, -1

        $sequence_8 = { 8d942428010000 f3ab b941000000 8d7c2424 f3ab }
            // n = 5, score = 200
            //   8d942428010000       | lea                 edx, [esp + 0x128]
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   b941000000           | mov                 ecx, 0x41
            //   8d7c2424             | lea                 edi, [esp + 0x24]
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax

        $sequence_9 = { c744246801010000 ff15???????? 8b442408 8b35???????? }
            // n = 4, score = 200
            //   c744246801010000     | mov                 dword ptr [esp + 0x68], 0x101
            //   ff15????????         |                     
            //   8b442408             | mov                 eax, dword ptr [esp + 8]
            //   8b35????????         |                     

    condition:
        7 of them and filesize < 131072
}