rule win_isaacwiper_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.isaacwiper."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.isaacwiper"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 48 0300 2448 0300 3448 0300 }
            // n = 6, score = 100
            //   48                   | dec                 eax
            //   0300                 | add                 eax, dword ptr [eax]
            //   2448                 | and                 al, 0x48
            //   0300                 | add                 eax, dword ptr [eax]
            //   3448                 | xor                 al, 0x48
            //   0300                 | add                 eax, dword ptr [eax]

        $sequence_1 = { 8d942498130000 8d8c24f0000000 e8???????? 84c0 0f84df0a0000 }
            // n = 5, score = 100
            //   8d942498130000       | lea                 edx, [esp + 0x1398]
            //   8d8c24f0000000       | lea                 ecx, [esp + 0xf0]
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   0f84df0a0000         | je                  0xae5

        $sequence_2 = { 8b7514 8d442418 8b7c2414 ff7614 6a00 50 57 }
            // n = 7, score = 100
            //   8b7514               | mov                 esi, dword ptr [ebp + 0x14]
            //   8d442418             | lea                 eax, [esp + 0x18]
            //   8b7c2414             | mov                 edi, dword ptr [esp + 0x14]
            //   ff7614               | push                dword ptr [esi + 0x14]
            //   6a00                 | push                0
            //   50                   | push                eax
            //   57                   | push                edi

        $sequence_3 = { 55 8bec 8b4508 56 57 8d3c8520650310 }
            // n = 6, score = 100
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   56                   | push                esi
            //   57                   | push                edi
            //   8d3c8520650310       | lea                 edi, [eax*4 + 0x10036520]

        $sequence_4 = { 8d442420 56 0f43442424 50 }
            // n = 4, score = 100
            //   8d442420             | lea                 eax, [esp + 0x20]
            //   56                   | push                esi
            //   0f43442424           | cmovae              eax, dword ptr [esp + 0x24]
            //   50                   | push                eax

        $sequence_5 = { c70700000000 8b7dfc c70200000000 5b 894740 }
            // n = 5, score = 100
            //   c70700000000         | mov                 dword ptr [edi], 0
            //   8b7dfc               | mov                 edi, dword ptr [ebp - 4]
            //   c70200000000         | mov                 dword ptr [edx], 0
            //   5b                   | pop                 ebx
            //   894740               | mov                 dword ptr [edi + 0x40], eax

        $sequence_6 = { 6bd738 8b0c8de8670310 c644112800 85f6 740c }
            // n = 5, score = 100
            //   6bd738               | imul                edx, edi, 0x38
            //   8b0c8de8670310       | mov                 ecx, dword ptr [ecx*4 + 0x100367e8]
            //   c644112800           | mov                 byte ptr [ecx + edx + 0x28], 0
            //   85f6                 | test                esi, esi
            //   740c                 | je                  0xe

        $sequence_7 = { 57 52 ba0a020000 8d8d90fbffff }
            // n = 4, score = 100
            //   57                   | push                edi
            //   52                   | push                edx
            //   ba0a020000           | mov                 edx, 0x20a
            //   8d8d90fbffff         | lea                 ecx, [ebp - 0x470]

        $sequence_8 = { 89842488000000 8d8424c0000000 50 c7460800000000 }
            // n = 4, score = 100
            //   89842488000000       | mov                 dword ptr [esp + 0x88], eax
            //   8d8424c0000000       | lea                 eax, [esp + 0xc0]
            //   50                   | push                eax
            //   c7460800000000       | mov                 dword ptr [esi + 8], 0

        $sequence_9 = { 8b4804 8d41f8 89443194 8b4688 8b4004 c744308898270310 8b4688 }
            // n = 7, score = 100
            //   8b4804               | mov                 ecx, dword ptr [eax + 4]
            //   8d41f8               | lea                 eax, [ecx - 8]
            //   89443194             | mov                 dword ptr [ecx + esi - 0x6c], eax
            //   8b4688               | mov                 eax, dword ptr [esi - 0x78]
            //   8b4004               | mov                 eax, dword ptr [eax + 4]
            //   c744308898270310     | mov                 dword ptr [eax + esi - 0x78], 0x10032798
            //   8b4688               | mov                 eax, dword ptr [esi - 0x78]

    condition:
        7 of them and filesize < 467968
}