rule win_jaff_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.jaff."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.jaff"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 13c9 66f3ab 8b7de8 8d043f 50 6a08 }
            // n = 6, score = 600
            //   13c9                 | adc                 ecx, ecx
            //   66f3ab               | rep stosd           dword ptr es:[edi], eax
            //   8b7de8               | mov                 edi, dword ptr [ebp - 0x18]
            //   8d043f               | lea                 eax, [edi + edi]
            //   50                   | push                eax
            //   6a08                 | push                8

        $sequence_1 = { 7402 d8ca d1e8 7411 }
            // n = 4, score = 600
            //   7402                 | je                  4
            //   d8ca                 | fmul                st(2)
            //   d1e8                 | shr                 eax, 1
            //   7411                 | je                  0x13

        $sequence_2 = { 8b5598 52 6a00 ffd3 50 ffd6 }
            // n = 6, score = 600
            //   8b5598               | mov                 edx, dword ptr [ebp - 0x68]
            //   52                   | push                edx
            //   6a00                 | push                0
            //   ffd3                 | call                ebx
            //   50                   | push                eax
            //   ffd6                 | call                esi

        $sequence_3 = { 66833c4200 7508 3bce 7506 }
            // n = 4, score = 600
            //   66833c4200           | cmp                 word ptr [edx + eax*2], 0
            //   7508                 | jne                 0xa
            //   3bce                 | cmp                 ecx, esi
            //   7506                 | jne                 8

        $sequence_4 = { 8a470c 51 6a08 8975bc 8845c0 ffd3 }
            // n = 6, score = 600
            //   8a470c               | mov                 al, byte ptr [edi + 0xc]
            //   51                   | push                ecx
            //   6a08                 | push                8
            //   8975bc               | mov                 dword ptr [ebp - 0x44], esi
            //   8845c0               | mov                 byte ptr [ebp - 0x40], al
            //   ffd3                 | call                ebx

        $sequence_5 = { 8b5590 52 6a00 ffd7 50 ffd6 53 }
            // n = 7, score = 600
            //   8b5590               | mov                 edx, dword ptr [ebp - 0x70]
            //   52                   | push                edx
            //   6a00                 | push                0
            //   ffd7                 | call                edi
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   53                   | push                ebx

        $sequence_6 = { 90 668b340a 668931 83c102 ff4df8 75f1 50 }
            // n = 7, score = 600
            //   90                   | nop                 
            //   668b340a             | mov                 si, word ptr [edx + ecx]
            //   668931               | mov                 word ptr [ecx], si
            //   83c102               | add                 ecx, 2
            //   ff4df8               | dec                 dword ptr [ebp - 8]
            //   75f1                 | jne                 0xfffffff3
            //   50                   | push                eax

        $sequence_7 = { 0f82a5feffff 8b4d14 51 6a00 }
            // n = 4, score = 600
            //   0f82a5feffff         | jb                  0xfffffeab
            //   8b4d14               | mov                 ecx, dword ptr [ebp + 0x14]
            //   51                   | push                ecx
            //   6a00                 | push                0

        $sequence_8 = { 8b55f8 8945d4 8b450c 8b08 0fbe0411 }
            // n = 5, score = 600
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   8945d4               | mov                 dword ptr [ebp - 0x2c], eax
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   0fbe0411             | movsx               eax, byte ptr [ecx + edx]

        $sequence_9 = { 6a08 c745e000000000 c745e40a000000 c645e801 ffd3 50 }
            // n = 6, score = 600
            //   6a08                 | push                8
            //   c745e000000000       | mov                 dword ptr [ebp - 0x20], 0
            //   c745e40a000000       | mov                 dword ptr [ebp - 0x1c], 0xa
            //   c645e801             | mov                 byte ptr [ebp - 0x18], 1
            //   ffd3                 | call                ebx
            //   50                   | push                eax

    condition:
        7 of them and filesize < 106496
}