rule win_jasus_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.jasus."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.jasus"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 668b5304 83ec08 8bc4 8930 66897804 83ec08 8bc4 }
            // n = 7, score = 200
            //   668b5304             | mov                 dx, word ptr [ebx + 4]
            //   83ec08               | sub                 esp, 8
            //   8bc4                 | mov                 eax, esp
            //   8930                 | mov                 dword ptr [eax], esi
            //   66897804             | mov                 word ptr [eax + 4], di
            //   83ec08               | sub                 esp, 8
            //   8bc4                 | mov                 eax, esp

        $sequence_1 = { 52 ff15???????? 8b4608 50 68???????? e8???????? 68???????? }
            // n = 7, score = 200
            //   52                   | push                edx
            //   ff15????????         |                     
            //   8b4608               | mov                 eax, dword ptr [esi + 8]
            //   50                   | push                eax
            //   68????????           |                     
            //   e8????????           |                     
            //   68????????           |                     

        $sequence_2 = { 41 ebf3 68???????? 51 894dec 894de8 e8???????? }
            // n = 7, score = 200
            //   41                   | inc                 ecx
            //   ebf3                 | jmp                 0xfffffff5
            //   68????????           |                     
            //   51                   | push                ecx
            //   894dec               | mov                 dword ptr [ebp - 0x14], ecx
            //   894de8               | mov                 dword ptr [ebp - 0x18], ecx
            //   e8????????           |                     

        $sequence_3 = { 81e7ff000000 894e04 3304bda0ca4100 8bf8 8b442418 }
            // n = 5, score = 200
            //   81e7ff000000         | and                 edi, 0xff
            //   894e04               | mov                 dword ptr [esi + 4], ecx
            //   3304bda0ca4100       | xor                 eax, dword ptr [edi*4 + 0x41caa0]
            //   8bf8                 | mov                 edi, eax
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]

        $sequence_4 = { 6a07 c1f804 59 8985a4fbffff 3bc1 0f87260a0000 ff248514274100 }
            // n = 7, score = 200
            //   6a07                 | push                7
            //   c1f804               | sar                 eax, 4
            //   59                   | pop                 ecx
            //   8985a4fbffff         | mov                 dword ptr [ebp - 0x45c], eax
            //   3bc1                 | cmp                 eax, ecx
            //   0f87260a0000         | ja                  0xa2c
            //   ff248514274100       | jmp                 dword ptr [eax*4 + 0x412714]

        $sequence_5 = { 668b1d???????? 898d78ffffff 668b0d???????? 899564ffffff 8b15???????? 66898d68ffffff 89957cffffff }
            // n = 7, score = 200
            //   668b1d????????       |                     
            //   898d78ffffff         | mov                 dword ptr [ebp - 0x88], ecx
            //   668b0d????????       |                     
            //   899564ffffff         | mov                 dword ptr [ebp - 0x9c], edx
            //   8b15????????         |                     
            //   66898d68ffffff       | mov                 word ptr [ebp - 0x98], cx
            //   89957cffffff         | mov                 dword ptr [ebp - 0x84], edx

        $sequence_6 = { 50 68???????? 51 e8???????? 8b9dccfaffff 83c418 32c9 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   68????????           |                     
            //   51                   | push                ecx
            //   e8????????           |                     
            //   8b9dccfaffff         | mov                 ebx, dword ptr [ebp - 0x534]
            //   83c418               | add                 esp, 0x18
            //   32c9                 | xor                 cl, cl

        $sequence_7 = { 56 8b7508 8bc6 c1f805 8d1485809d4300 8b0a 83e61f }
            // n = 7, score = 200
            //   56                   | push                esi
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   8bc6                 | mov                 eax, esi
            //   c1f805               | sar                 eax, 5
            //   8d1485809d4300       | lea                 edx, [eax*4 + 0x439d80]
            //   8b0a                 | mov                 ecx, dword ptr [edx]
            //   83e61f               | and                 esi, 0x1f

        $sequence_8 = { 51 8d5580 52 8d857cffffff 50 8d8d78ffffff }
            // n = 6, score = 200
            //   51                   | push                ecx
            //   8d5580               | lea                 edx, [ebp - 0x80]
            //   52                   | push                edx
            //   8d857cffffff         | lea                 eax, [ebp - 0x84]
            //   50                   | push                eax
            //   8d8d78ffffff         | lea                 ecx, [ebp - 0x88]

        $sequence_9 = { 833d????????00 0fb75708 8b4f04 8b07 66899568feffff 0fb715???????? 898d64feffff }
            // n = 7, score = 200
            //   833d????????00       |                     
            //   0fb75708             | movzx               edx, word ptr [edi + 8]
            //   8b4f04               | mov                 ecx, dword ptr [edi + 4]
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   66899568feffff       | mov                 word ptr [ebp - 0x198], dx
            //   0fb715????????       |                     
            //   898d64feffff         | mov                 dword ptr [ebp - 0x19c], ecx

    condition:
        7 of them and filesize < 507904
}