rule win_jinxloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.jinxloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.jinxloader"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? e8???????? e8???????? 488b442450 6690 e8???????? 488d0529305400 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   e8????????           |                     
            //   e8????????           |                     
            //   488b442450           | inc                 esp
            //   6690                 | cmp                 byte ptr [eax + 0x2aa], cl
            //   e8????????           |                     
            //   488d0529305400       | jae                 0x18b

        $sequence_1 = { 4d09c4 4921d3 4d09cb 4c21d2 4809c2 90 48894c2420 }
            // n = 7, score = 100
            //   4d09c4               | dec                 esp
            //   4921d3               | mov                 eax, dword ptr [esp + 0x118]
            //   4d09cb               | dec                 eax
            //   4c21d2               | mov                 ecx, dword ptr [esp + 0x110]
            //   4809c2               | dec                 eax
            //   90                   | mov                 ebx, dword ptr [esp + 0x1c0]
            //   48894c2420           | dec                 eax

        $sequence_2 = { eb0a 488b4c2470 488b5c2460 488b9424e8000000 48899a80020000 833d????????00 7413 }
            // n = 7, score = 100
            //   eb0a                 | mov                 ecx, dword ptr [esp + 0xdd0]
            //   488b4c2470           | dec                 ecx
            //   488b5c2460           | mov                 dword ptr [ebx], ecx
            //   488b9424e8000000     | dec                 ecx
            //   48899a80020000       | mov                 dword ptr [ebx + 8], eax
            //   833d????????00       |                     
            //   7413                 | jne                 0x1de0

        $sequence_3 = { eb1d 440fb64c3419 4129d1 418d5121 88543c19 418d5021 88543419 }
            // n = 7, score = 100
            //   eb1d                 | dec                 eax
            //   440fb64c3419         | mov                 dword ptr [esp + 0xa8], eax
            //   4129d1               | dec                 eax
            //   418d5121             | mov                 dword ptr [esp + 0x28], ebx
            //   88543c19             | jl                  0xe05
            //   418d5021             | xor                 eax, eax
            //   88543419             | dec                 eax

        $sequence_4 = { 84c9 740d b802000000 31db 4883c420 5d c3 }
            // n = 7, score = 100
            //   84c9                 | je                  0xda2
            //   740d                 | cmp                 byte ptr [ecx], 0x20
            //   b802000000           | dec                 eax
            //   31db                 | sar                 edx, 0x3f
            //   4883c420             | and                 edx, 1
            //   5d                   | dec                 eax
            //   c3                   | add                 ebx, edx

        $sequence_5 = { eb12 4531e4 31ff 4531ed eb08 4531e4 31ff }
            // n = 7, score = 100
            //   eb12                 | dec                 eax
            //   4531e4               | mov                 ebp, esp
            //   31ff                 | dec                 eax
            //   4531ed               | sub                 esp, 0x100
            //   eb08                 | dec                 ebp
            //   4531e4               | mov                 esp, dword ptr [esi + 0x20]
            //   31ff                 | dec                 ebp

        $sequence_6 = { e9???????? 4889d9 6690 e8???????? 440f117c2460 440f117c2470 488d1568010000 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   4889d9               | test                edi, edi
            //   6690                 | jne                 0x1f53
            //   e8????????           |                     
            //   440f117c2460         | xor                 ecx, ecx
            //   440f117c2470         | jmp                 0x1f89
            //   488d1568010000       | dec                 esp

        $sequence_7 = { e9???????? 90 488dbc24e0000000 488d7fe0 0f1f8000000000 48896c24f0 488d6c24f0 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   90                   | jne                 0x1fd1
            //   488dbc24e0000000     | dec                 eax
            //   488d7fe0             | mov                 dword ptr [esp + 8], 0x4000
            //   0f1f8000000000       | dec                 eax
            //   48896c24f0           | lea                 eax, [esp + 8]
            //   488d6c24f0           | dec                 eax

        $sequence_8 = { e8???????? 488b8c24b8000000 49890b 488b9424c0000000 49895308 48894818 48895020 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488b8c24b8000000     | nop                 
            //   49890b               | dec                 eax
            //   488b9424c0000000     | mov                 dword ptr [esp + 8], eax
            //   49895308             | nop                 
            //   48894818             | dec                 eax
            //   48895020             | mov                 ebx, eax

        $sequence_9 = { e8???????? 4883c418 5d c3 4889442428 488d0582005500 6690 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4883c418             | nop                 
            //   5d                   | dec                 eax
            //   c3                   | lea                 ebx, [0x4b5793]
            //   4889442428           | dec                 eax
            //   488d0582005500       | lea                 ecx, [0xc4653]
            //   6690                 | dec                 ebp

    condition:
        7 of them and filesize < 20364288
}