rule win_joao_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.joao."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.joao"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a00 6a00 68b0000000 b9???????? e8???????? }
            // n = 5, score = 400
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   68b0000000           | push                0xb0
            //   b9????????           |                     
            //   e8????????           |                     

        $sequence_1 = { 833f10 720e 8b03 50 e8???????? 8b4510 }
            // n = 6, score = 400
            //   833f10               | cmp                 dword ptr [edi], 0x10
            //   720e                 | jb                  0x10
            //   8b03                 | mov                 eax, dword ptr [ebx]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]

        $sequence_2 = { 741c 8b0f 8908 8d4804 83c704 }
            // n = 5, score = 400
            //   741c                 | je                  0x1e
            //   8b0f                 | mov                 ecx, dword ptr [edi]
            //   8908                 | mov                 dword ptr [eax], ecx
            //   8d4804               | lea                 ecx, [eax + 4]
            //   83c704               | add                 edi, 4

        $sequence_3 = { 40 50 8d4ef0 51 53 e8???????? }
            // n = 6, score = 400
            //   40                   | inc                 eax
            //   50                   | push                eax
            //   8d4ef0               | lea                 ecx, [esi - 0x10]
            //   51                   | push                ecx
            //   53                   | push                ebx
            //   e8????????           |                     

        $sequence_4 = { e8???????? 83c404 897e14 897e18 897e1c 8b4604 }
            // n = 6, score = 400
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   897e14               | mov                 dword ptr [esi + 0x14], edi
            //   897e18               | mov                 dword ptr [esi + 0x18], edi
            //   897e1c               | mov                 dword ptr [esi + 0x1c], edi
            //   8b4604               | mov                 eax, dword ptr [esi + 4]

        $sequence_5 = { c745d000000000 85c9 746f 8b4320 03c6 8945cc }
            // n = 6, score = 400
            //   c745d000000000       | mov                 dword ptr [ebp - 0x30], 0
            //   85c9                 | test                ecx, ecx
            //   746f                 | je                  0x71
            //   8b4320               | mov                 eax, dword ptr [ebx + 0x20]
            //   03c6                 | add                 eax, esi
            //   8945cc               | mov                 dword ptr [ebp - 0x34], eax

        $sequence_6 = { 837de810 8b45d4 7303 8d45d4 52 51 50 }
            // n = 7, score = 400
            //   837de810             | cmp                 dword ptr [ebp - 0x18], 0x10
            //   8b45d4               | mov                 eax, dword ptr [ebp - 0x2c]
            //   7303                 | jae                 5
            //   8d45d4               | lea                 eax, [ebp - 0x2c]
            //   52                   | push                edx
            //   51                   | push                ecx
            //   50                   | push                eax

        $sequence_7 = { 52 8d4dd0 e8???????? 83f8ff 740b 6aff 50 }
            // n = 7, score = 400
            //   52                   | push                edx
            //   8d4dd0               | lea                 ecx, [ebp - 0x30]
            //   e8????????           |                     
            //   83f8ff               | cmp                 eax, -1
            //   740b                 | je                  0xd
            //   6aff                 | push                -1
            //   50                   | push                eax

        $sequence_8 = { 3bd1 7299 837de810 720c }
            // n = 4, score = 400
            //   3bd1                 | cmp                 edx, ecx
            //   7299                 | jb                  0xffffff9b
            //   837de810             | cmp                 dword ptr [ebp - 0x18], 0x10
            //   720c                 | jb                  0xe

        $sequence_9 = { 52 8bce c745f802000000 897dfc e8???????? }
            // n = 5, score = 400
            //   52                   | push                edx
            //   8bce                 | mov                 ecx, esi
            //   c745f802000000       | mov                 dword ptr [ebp - 8], 2
            //   897dfc               | mov                 dword ptr [ebp - 4], edi
            //   e8????????           |                     

    condition:
        7 of them and filesize < 2867200
}