rule win_karkoff_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.karkoff"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 3a05???????? 08ed 17 0200 }
            // n = 4, score = 100
            //   3a05????????         |                     
            //   08ed                 | or                  ch, ch
            //   17                   | pop                 ss
            //   0200                 | add                 al, byte ptr [eax]

        $sequence_1 = { 0011 1001 0115???????? 1e 0015???????? }
            // n = 5, score = 100
            //   0011                 | add                 byte ptr [ecx], dl
            //   1001                 | adc                 byte ptr [ecx], al
            //   0115????????         |                     
            //   1e                   | push                ds
            //   0015????????         |                     

        $sequence_2 = { 08a712020092 b301 001c17 3437 0500000096 08d1 }
            // n = 6, score = 100
            //   08a712020092         | or                  byte ptr [edi - 0x6dfffdee], ah
            //   b301                 | mov                 bl, 1
            //   001c17               | add                 byte ptr [edi + edx], bl
            //   3437                 | xor                 al, 0x37
            //   0500000096           | add                 eax, 0x96000000
            //   08d1                 | or                  cl, dl

        $sequence_3 = { 0111 818d0500001282c40520 0012 829c0a3001001511 }
            // n = 4, score = 100
            //   0111                 | add                 dword ptr [ecx], edx
            //   818d0500001282c40520     | or    dword ptr [ebp + 0x12000005], 0x2005c482
            //   0012                 | add                 byte ptr [edx], dl
            //   829c0a3001001511     | sbb                 byte ptr [edx + ecx + 0x15000130], 0x11

        $sequence_4 = { 1282bd062001 0112 82bd0520001282 c10620 }
            // n = 4, score = 100
            //   1282bd062001         | adc                 al, byte ptr [edx + 0x12006bd]
            //   0112                 | add                 dword ptr [edx], edx
            //   82bd0520001282       | cmp                 byte ptr [ebp + 0x12002005], 0x82
            //   c10620               | rol                 dword ptr [esi], 0x20

        $sequence_5 = { 3505000000 96 08bb10020092 b301 001c17 }
            // n = 5, score = 100
            //   3505000000           | xor                 eax, 5
            //   96                   | xchg                eax, esi
            //   08bb10020092         | or                  byte ptr [ebx - 0x6dfffdf0], bh
            //   b301                 | mov                 bl, 1
            //   001c17               | add                 byte ptr [edi + edx], bl

        $sequence_6 = { 1282c00e0c20 0215???????? 1282c00e020a 2001 1512811101 1c12 }
            // n = 6, score = 100
            //   1282c00e0c20         | adc                 al, byte ptr [edx + 0x200c0ec0]
            //   0215????????         |                     
            //   1282c00e020a         | adc                 al, byte ptr [edx + 0xa020ec0]
            //   2001                 | and                 byte ptr [ecx], al
            //   1512811101           | adc                 eax, 0x1118112
            //   1c12                 | sbb                 al, 0x12

        $sequence_7 = { 086814 0200 92 b301 }
            // n = 4, score = 100
            //   086814               | or                  byte ptr [eax + 0x14], ch
            //   0200                 | add                 al, byte ptr [eax]
            //   92                   | xchg                eax, edx
            //   b301                 | mov                 bl, 1

        $sequence_8 = { 0815???????? b301 001c17 d436 0500000096 }
            // n = 5, score = 100
            //   0815????????         |                     
            //   b301                 | mov                 bl, 1
            //   001c17               | add                 byte ptr [edi + edx], bl
            //   d436                 | aam                 0x36
            //   0500000096           | add                 eax, 0x96000000

        $sequence_9 = { 12826d060001 0212 82c006 2001 0112 }
            // n = 5, score = 100
            //   12826d060001         | adc                 al, byte ptr [edx + 0x100066d]
            //   0212                 | add                 dl, byte ptr [edx]
            //   82c006               | add                 al, 6
            //   2001                 | and                 byte ptr [ecx], al
            //   0112                 | add                 dword ptr [edx], edx

        $sequence_10 = { 6974792077696c6c 206265 207265 6d 6f 7665 }
            // n = 6, score = 100
            //   6974792077696c6c     | imul                esi, dword ptr [ecx + edi*2 + 0x20], 0x6c6c6977
            //   206265               | and                 byte ptr [edx + 0x65], ah
            //   207265               | and                 byte ptr [edx + 0x65], dh
            //   6d                   | insd                dword ptr es:[edi], dx
            //   6f                   | outsd               dx, dword ptr [esi]
            //   7665                 | jbe                 0x67

        $sequence_11 = { 6af0 07 68d7010000 00e6 01ab657100f1 07 }
            // n = 6, score = 100
            //   6af0                 | push                -0x10
            //   07                   | pop                 es
            //   68d7010000           | push                0x1d7
            //   00e6                 | add                 dh, ah
            //   01ab657100f1         | add                 dword ptr [ebx - 0xeff8e9b], ebp
            //   07                   | pop                 es

        $sequence_12 = { 0212 83801020050112 80801283701282 d10e 128380102005 0112 80801283701283 }
            // n = 7, score = 100
            //   0212                 | add                 dl, byte ptr [edx]
            //   83801020050112       | add                 dword ptr [eax + 0x1052010], 0x12
            //   80801283701282       | add                 byte ptr [eax + 0x12708312], 0x82
            //   d10e                 | ror                 dword ptr [esi], 1
            //   128380102005         | adc                 al, byte ptr [ebx + 0x5201080]
            //   0112                 | add                 dword ptr [edx], edx
            //   80801283701283       | add                 byte ptr [eax + 0x12708312], 0x83

        $sequence_13 = { 04c0 5b 0100 0000 c3 0292430100a4 }
            // n = 6, score = 100
            //   04c0                 | add                 al, 0xc0
            //   5b                   | pop                 ebx
            //   0100                 | add                 dword ptr [eax], eax
            //   0000                 | add                 byte ptr [eax], al
            //   c3                   | ret                 
            //   0292430100a4         | add                 dl, byte ptr [edx - 0x5bfffebd]

        $sequence_14 = { b301 001c17 ac 37 0500000096 086d13 0200 }
            // n = 7, score = 100
            //   b301                 | mov                 bl, 1
            //   001c17               | add                 byte ptr [edi + edx], bl
            //   ac                   | lodsb               al, byte ptr [esi]
            //   37                   | aaa                 
            //   0500000096           | add                 eax, 0x96000000
            //   086d13               | or                  byte ptr [ebp + 0x13], ch
            //   0200                 | add                 al, byte ptr [eax]

        $sequence_15 = { 3505000000 96 086c1002 0092b301001c 17 b435 0500000096 }
            // n = 7, score = 100
            //   3505000000           | xor                 eax, 5
            //   96                   | xchg                eax, esi
            //   086c1002             | or                  byte ptr [eax + edx + 2], ch
            //   0092b301001c         | add                 byte ptr [edx + 0x1c0001b3], dl
            //   17                   | pop                 ss
            //   b435                 | mov                 ah, 0x35
            //   0500000096           | add                 eax, 0x96000000

    condition:
        7 of them and filesize < 2383872
}