rule win_kdcsponge_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.kdcsponge."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.kdcsponge"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 3881c3040000 7506 8881c5040000 e8???????? 488d8b44030000 488bd3 4883c420 }
            // n = 7, score = 100
            //   3881c3040000         | cmp                 byte ptr [ecx + 0x4c2], 2
            //   7506                 | jne                 0x1c0a
            //   8881c5040000         | mov                 dword ptr [ecx + 0x4ca], 0x10
            //   e8????????           |                     
            //   488d8b44030000       | dec                 eax
            //   488bd3               | add                 ecx, 0x110
            //   4883c420             | dec                 eax

        $sequence_1 = { 418d4102 83f801 761e 498bc9 488d1553b40100 83e13f 498bc1 }
            // n = 7, score = 100
            //   418d4102             | mov                 dword ptr [ebx + 0x27c], 1
            //   83f801               | and                 ecx, 0xf
            //   761e                 | dec                 eax
            //   498bc9               | mov                 dword ptr [ebx + 0x1e4], 0x20000
            //   488d1553b40100       | mov                 eax, ecx
            //   83e13f               | dec                 eax
            //   498bc1               | mov                 dword ptr [ebx + 0x214], 0x1000

        $sequence_2 = { c781a004000002000000 c7416000002000 48c7812801000000000200 48c7815801000001000000 48c7816001000001000000 c7813001000020000000 }
            // n = 6, score = 100
            //   c781a004000002000000     | dec    eax
            //   c7416000002000       | mov                 dword ptr [ebx + 0x244], 4
            //   48c7812801000000000200     | dec    eax
            //   48c7815801000001000000     | add    esp, 0x20
            //   48c7816001000001000000     | pop    ebx
            //   c7813001000020000000     | ret    

        $sequence_3 = { c745d408574883 488d0d084a0200 c745d8ec20488b c745dc7918488b c745e0d94885ff c745e40f8500c5 c745e8010033c0 }
            // n = 7, score = 100
            //   c745d408574883       | lea                 ebx, [esp + 0x170]
            //   488d0d084a0200       | dec                 ecx
            //   c745d8ec20488b       | mov                 ebx, dword ptr [ebx + 0x10]
            //   c745dc7918488b       | dec                 ecx
            //   c745e0d94885ff       | mov                 esi, dword ptr [ebx + 0x18]
            //   c745e40f8500c5       | dec                 ecx
            //   c745e8010033c0       | mov                 esp, ebx

        $sequence_4 = { 8b8b60040000 83c102 c7837c04000008000000 48ffc1 48018b20040000 488b8b6c040000 488b8320040000 }
            // n = 7, score = 100
            //   8b8b60040000         | sub                 esp, 0x20
            //   83c102               | cmp                 dword ptr [ecx + 0x488], 1
            //   c7837c04000008000000     | dec    eax
            //   48ffc1               | mov                 ebx, ecx
            //   48018b20040000       | movzx               eax, byte ptr [ecx + 0x4c3]
            //   488b8b6c040000       | mov                 dword ptr [ecx + 0x47c], 8
            //   488b8320040000       | jne                 0xe97

        $sequence_5 = { 4d85c0 7428 488b8220040000 48ffc0 493bc0 7219 c782a904000001000000 }
            // n = 7, score = 100
            //   4d85c0               | cmp                 eax, 0x40
            //   7428                 | je                  0xc24
            //   488b8220040000       | mov                 dword ptr [ebx + 0x43c], edi
            //   48ffc0               | movzx               eax, byte ptr [ecx]
            //   493bc0               | mov                 dword ptr [ebx + 0x64], eax
            //   7219                 | jmp                 0xc38
            //   c782a904000001000000     | inc    ecx

        $sequence_6 = { 488d1565f50300 488b04c2 48898160010000 48ff8120040000 48c781e401000000000300 48c781f801000010000000 48c781a000000001000000 }
            // n = 7, score = 100
            //   488d1565f50300       | xor                 eax, eax
            //   488b04c2             | mov                 dword ptr [ebx + 0x4ca], eax
            //   48898160010000       | jmp                 0x758
            //   48ff8120040000       | mov                 dword ptr [ecx + 0x440], 0x68
            //   48c781e401000000000300     | dec    eax
            //   48c781f801000010000000     | add    ecx, 0x1cc
            //   48c781a000000001000000     | xor    eax, eax

        $sequence_7 = { 488b8320040000 488d9344030000 4c8bc3 0fb648ff c1e904 4883c420 5b }
            // n = 7, score = 100
            //   488b8320040000       | arpl                ax, ax
            //   488d9344030000       | dec                 eax
            //   4c8bc3               | lea                 ecx, [eax + eax*4]
            //   0fb648ff             | ret                 
            //   c1e904               | dec                 ecx
            //   4883c420             | mov                 eax, dword ptr [eax + 0x420]
            //   5b                   | mov                 ecx, dword ptr [eax + 3]

        $sequence_8 = { e9???????? 8b8138040000 89813c040000 c6810904000008 c7814004000070000000 eb44 80b9b104000001 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8b8138040000         | dec                 eax
            //   89813c040000         | mov                 dword ptr [ecx + 0x160], 1
            //   c6810904000008       | dec                 eax
            //   c7814004000070000000     | mov    dword ptr [ecx + 0x1e4], 0x20000
            //   eb44                 | dec                 eax
            //   80b9b104000001       | mov                 dword ptr [ecx + 0x214], 1

        $sequence_9 = { c7416000000100 48c7812801000000000200 48c7815801000001000000 48c7816001000001000000 c7813001000040000000 c3 33c0 }
            // n = 7, score = 100
            //   c7416000000100       | cmp                 edi, 0x40
            //   48c7812801000000000200     | dec    eax
            //   48c7815801000001000000     | mov    edi, dword ptr [esp + 0x30]
            //   48c7816001000001000000     | dec    eax
            //   c7813001000040000000     | mov    dword ptr [ebx + 0x1e4], 0x20000
            //   c3                   | dec                 eax
            //   33c0                 | mov                 dword ptr [ebx + 0x214], 0x20

    condition:
        7 of them and filesize < 720896
}