rule win_kegotip_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.kegotip."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.kegotip"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 68???????? 6801000080 ff15???????? 8985ecfeffff }
            // n = 4, score = 600
            //   68????????           |                     
            //   6801000080           | push                0x80000001
            //   ff15????????         |                     
            //   8985ecfeffff         | mov                 dword ptr [ebp - 0x114], eax

        $sequence_1 = { 0fbe940dd6feffff 83fa5c 750e 8b85d4feffff c68405d6feffff00 8d8dd8feffff }
            // n = 6, score = 600
            //   0fbe940dd6feffff     | movsx               edx, byte ptr [ebp + ecx - 0x12a]
            //   83fa5c               | cmp                 edx, 0x5c
            //   750e                 | jne                 0x10
            //   8b85d4feffff         | mov                 eax, dword ptr [ebp - 0x12c]
            //   c68405d6feffff00     | mov                 byte ptr [ebp + eax - 0x12a], 0
            //   8d8dd8feffff         | lea                 ecx, [ebp - 0x128]

        $sequence_2 = { 3b4514 7304 33c0 eb58 c745fc00000000 c745f800000000 }
            // n = 6, score = 600
            //   3b4514               | cmp                 eax, dword ptr [ebp + 0x14]
            //   7304                 | jae                 6
            //   33c0                 | xor                 eax, eax
            //   eb58                 | jmp                 0x5a
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   c745f800000000       | mov                 dword ptr [ebp - 8], 0

        $sequence_3 = { 52 ff15???????? 83bd6cfeffff00 7502 eb36 8b8560feffff }
            // n = 6, score = 600
            //   52                   | push                edx
            //   ff15????????         |                     
            //   83bd6cfeffff00       | cmp                 dword ptr [ebp - 0x194], 0
            //   7502                 | jne                 4
            //   eb36                 | jmp                 0x38
            //   8b8560feffff         | mov                 eax, dword ptr [ebp - 0x1a0]

        $sequence_4 = { 898da8feffff 8995acfeffff 8b85acfeffff 3b45fc 7214 770b 8b8da8feffff }
            // n = 7, score = 600
            //   898da8feffff         | mov                 dword ptr [ebp - 0x158], ecx
            //   8995acfeffff         | mov                 dword ptr [ebp - 0x154], edx
            //   8b85acfeffff         | mov                 eax, dword ptr [ebp - 0x154]
            //   3b45fc               | cmp                 eax, dword ptr [ebp - 4]
            //   7214                 | jb                  0x16
            //   770b                 | ja                  0xd
            //   8b8da8feffff         | mov                 ecx, dword ptr [ebp - 0x158]

        $sequence_5 = { ff15???????? 83f803 7402 ebc2 6a00 6a04 8b45dc }
            // n = 7, score = 600
            //   ff15????????         |                     
            //   83f803               | cmp                 eax, 3
            //   7402                 | je                  4
            //   ebc2                 | jmp                 0xffffffc4
            //   6a00                 | push                0
            //   6a04                 | push                4
            //   8b45dc               | mov                 eax, dword ptr [ebp - 0x24]

        $sequence_6 = { 7412 0fbe4508 83f823 7409 c745fc00000000 eb07 }
            // n = 6, score = 600
            //   7412                 | je                  0x14
            //   0fbe4508             | movsx               eax, byte ptr [ebp + 8]
            //   83f823               | cmp                 eax, 0x23
            //   7409                 | je                  0xb
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   eb07                 | jmp                 9

        $sequence_7 = { 32c0 e9???????? 8d85d8feffff 50 6804010000 ff15???????? }
            // n = 6, score = 600
            //   32c0                 | xor                 al, al
            //   e9????????           |                     
            //   8d85d8feffff         | lea                 eax, [ebp - 0x128]
            //   50                   | push                eax
            //   6804010000           | push                0x104
            //   ff15????????         |                     

        $sequence_8 = { ff15???????? c645ff01 8b45f0 50 ff15???????? }
            // n = 5, score = 600
            //   ff15????????         |                     
            //   c645ff01             | mov                 byte ptr [ebp - 1], 1
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_9 = { c745f400000000 6a00 8d55f4 52 6a00 6a00 6a01 }
            // n = 7, score = 600
            //   c745f400000000       | mov                 dword ptr [ebp - 0xc], 0
            //   6a00                 | push                0
            //   8d55f4               | lea                 edx, [ebp - 0xc]
            //   52                   | push                edx
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a01                 | push                1

    condition:
        7 of them and filesize < 278528
}