rule win_ketrican_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.ketrican."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ketrican"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8965f0 33db 895dfc 33c0 }
            // n = 4, score = 700
            //   8965f0               | mov                 dword ptr [ebp - 0x10], esp
            //   33db                 | xor                 ebx, ebx
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx
            //   33c0                 | xor                 eax, eax

        $sequence_1 = { 8906 c3 56 8bf1 57 8bf8 }
            // n = 6, score = 600
            //   8906                 | mov                 dword ptr [esi], eax
            //   c3                   | ret                 
            //   56                   | push                esi
            //   8bf1                 | mov                 esi, ecx
            //   57                   | push                edi
            //   8bf8                 | mov                 edi, eax

        $sequence_2 = { 7505 e8???????? 83c010 8906 c3 56 }
            // n = 6, score = 600
            //   7505                 | jne                 7
            //   e8????????           |                     
            //   83c010               | add                 eax, 0x10
            //   8906                 | mov                 dword ptr [esi], eax
            //   c3                   | ret                 
            //   56                   | push                esi

        $sequence_3 = { 8bc1 8945f0 834dfcff e8???????? }
            // n = 4, score = 600
            //   8bc1                 | mov                 eax, ecx
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   834dfcff             | or                  dword ptr [ebp - 4], 0xffffffff
            //   e8????????           |                     

        $sequence_4 = { 8901 5b 5d c20800 680e000780 }
            // n = 5, score = 600
            //   8901                 | mov                 dword ptr [ecx], eax
            //   5b                   | pop                 ebx
            //   5d                   | pop                 ebp
            //   c20800               | ret                 8
            //   680e000780           | push                0x8007000e

        $sequence_5 = { 8b06 5d c20400 55 8bec 8b4508 }
            // n = 6, score = 600
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   5d                   | pop                 ebp
            //   c20400               | ret                 4
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_6 = { cc 8b06 83e810 8b08 395008 7d13 85d2 }
            // n = 7, score = 600
            //   cc                   | int3                
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   83e810               | sub                 eax, 0x10
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   395008               | cmp                 dword ptr [eax + 8], edx
            //   7d13                 | jge                 0x15
            //   85d2                 | test                edx, edx

        $sequence_7 = { 680e000780 e8???????? cc 8b06 }
            // n = 4, score = 600
            //   680e000780           | push                0x8007000e
            //   e8????????           |                     
            //   cc                   | int3                
            //   8b06                 | mov                 eax, dword ptr [esi]

        $sequence_8 = { 6a66 58 668945d8 6a72 58 668945da }
            // n = 6, score = 500
            //   6a66                 | push                0x66
            //   58                   | pop                 eax
            //   668945d8             | mov                 word ptr [ebp - 0x28], ax
            //   6a72                 | push                0x72
            //   58                   | pop                 eax
            //   668945da             | mov                 word ptr [ebp - 0x26], ax

        $sequence_9 = { e8???????? 8b7d0c 83c40c 8bc7 }
            // n = 4, score = 500
            //   e8????????           |                     
            //   8b7d0c               | mov                 edi, dword ptr [ebp + 0xc]
            //   83c40c               | add                 esp, 0xc
            //   8bc7                 | mov                 eax, edi

        $sequence_10 = { 6a69 58 668945d4 6a65 58 668945d6 6a66 }
            // n = 7, score = 500
            //   6a69                 | push                0x69
            //   58                   | pop                 eax
            //   668945d4             | mov                 word ptr [ebp - 0x2c], ax
            //   6a65                 | push                0x65
            //   58                   | pop                 eax
            //   668945d6             | mov                 word ptr [ebp - 0x2a], ax
            //   6a66                 | push                0x66

        $sequence_11 = { 33ff 8bd8 897d0c 85db 7e13 }
            // n = 5, score = 500
            //   33ff                 | xor                 edi, edi
            //   8bd8                 | mov                 ebx, eax
            //   897d0c               | mov                 dword ptr [ebp + 0xc], edi
            //   85db                 | test                ebx, ebx
            //   7e13                 | jle                 0x15

        $sequence_12 = { 6a01 e8???????? 59 59 e8???????? 8bf0 }
            // n = 6, score = 500
            //   6a01                 | push                1
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax

        $sequence_13 = { 5e 5d c3 ff25???????? 6aff 50 }
            // n = 6, score = 500
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   ff25????????         |                     
            //   6aff                 | push                -1
            //   50                   | push                eax

        $sequence_14 = { 668945e6 668945e8 33c0 668945ea c745ec08020000 }
            // n = 5, score = 500
            //   668945e6             | mov                 word ptr [ebp - 0x1a], ax
            //   668945e8             | mov                 word ptr [ebp - 0x18], ax
            //   33c0                 | xor                 eax, eax
            //   668945ea             | mov                 word ptr [ebp - 0x16], ax
            //   c745ec08020000       | mov                 dword ptr [ebp - 0x14], 0x208

        $sequence_15 = { 0f840c000000 8365d4fe 8d4da4 e9???????? c3 8d4dbc e9???????? }
            // n = 7, score = 100
            //   0f840c000000         | je                  0x12
            //   8365d4fe             | and                 dword ptr [ebp - 0x2c], 0xfffffffe
            //   8d4da4               | lea                 ecx, [ebp - 0x5c]
            //   e9????????           |                     
            //   c3                   | ret                 
            //   8d4dbc               | lea                 ecx, [ebp - 0x44]
            //   e9????????           |                     

        $sequence_16 = { 8d420c 8b4ae8 33c8 e8???????? 8b8a4c010000 33c8 }
            // n = 6, score = 100
            //   8d420c               | lea                 eax, [edx + 0xc]
            //   8b4ae8               | mov                 ecx, dword ptr [edx - 0x18]
            //   33c8                 | xor                 ecx, eax
            //   e8????????           |                     
            //   8b8a4c010000         | mov                 ecx, dword ptr [edx + 0x14c]
            //   33c8                 | xor                 ecx, eax

        $sequence_17 = { 68???????? c705????????98824100 a3???????? c605????????00 e8???????? 59 c3 }
            // n = 7, score = 100
            //   68????????           |                     
            //   c705????????98824100     |     
            //   a3????????           |                     
            //   c605????????00       |                     
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   c3                   | ret                 

        $sequence_18 = { e8???????? 8b8a4c010000 33c8 e8???????? b8???????? e9???????? }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8b8a4c010000         | mov                 ecx, dword ptr [edx + 0x14c]
            //   33c8                 | xor                 ecx, eax
            //   e8????????           |                     
            //   b8????????           |                     
            //   e9????????           |                     

        $sequence_19 = { 33c8 e8???????? 8b8a8c2f0000 33c8 e8???????? b8???????? e9???????? }
            // n = 7, score = 100
            //   33c8                 | xor                 ecx, eax
            //   e8????????           |                     
            //   8b8a8c2f0000         | mov                 ecx, dword ptr [edx + 0x2f8c]
            //   33c8                 | xor                 ecx, eax
            //   e8????????           |                     
            //   b8????????           |                     
            //   e9????????           |                     

        $sequence_20 = { 8b8a38ffffff 33c8 e8???????? 8b8ae8060000 }
            // n = 4, score = 100
            //   8b8a38ffffff         | mov                 ecx, dword ptr [edx - 0xc8]
            //   33c8                 | xor                 ecx, eax
            //   e8????????           |                     
            //   8b8ae8060000         | mov                 ecx, dword ptr [edx + 0x6e8]

        $sequence_21 = { b8???????? e9???????? 8d45d0 e9???????? 8d4dd0 e9???????? 8d4de0 }
            // n = 7, score = 100
            //   b8????????           |                     
            //   e9????????           |                     
            //   8d45d0               | lea                 eax, [ebp - 0x30]
            //   e9????????           |                     
            //   8d4dd0               | lea                 ecx, [ebp - 0x30]
            //   e9????????           |                     
            //   8d4de0               | lea                 ecx, [ebp - 0x20]

        $sequence_22 = { e9???????? 8b4508 e9???????? 8b45ec }
            // n = 4, score = 100
            //   e9????????           |                     
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   e9????????           |                     
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]

    condition:
        7 of them and filesize < 1449984
}