rule win_keyhole_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.keyhole."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.keyhole"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 5b 8bc7 5f 5e 83c40c c3 6a05 }
            // n = 7, score = 100
            //   5b                   | pop                 ebx
            //   8bc7                 | mov                 eax, edi
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   83c40c               | add                 esp, 0xc
            //   c3                   | ret                 
            //   6a05                 | push                5

        $sequence_1 = { 5f c3 56 6a00 ffd3 50 ff15???????? }
            // n = 7, score = 100
            //   5f                   | pop                 edi
            //   c3                   | ret                 
            //   56                   | push                esi
            //   6a00                 | push                0
            //   ffd3                 | call                ebx
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_2 = { 25ff030000 0fbf8445a01c0000 8944242c 85c0 0f889b000000 8bc8 }
            // n = 6, score = 100
            //   25ff030000           | and                 eax, 0x3ff
            //   0fbf8445a01c0000     | movsx               eax, word ptr [ebp + eax*2 + 0x1ca0]
            //   8944242c             | mov                 dword ptr [esp + 0x2c], eax
            //   85c0                 | test                eax, eax
            //   0f889b000000         | js                  0xa1
            //   8bc8                 | mov                 ecx, eax

        $sequence_3 = { f3ab 8bcb 83e103 f3aa 8b442414 8a4c2413 eb18 }
            // n = 7, score = 100
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   8bcb                 | mov                 ecx, ebx
            //   83e103               | and                 ecx, 3
            //   f3aa                 | rep stosb           byte ptr es:[edi], al
            //   8b442414             | mov                 eax, dword ptr [esp + 0x14]
            //   8a4c2413             | mov                 cl, byte ptr [esp + 0x13]
            //   eb18                 | jmp                 0x1a

        $sequence_4 = { 0f57c0 c1e208 0bd0 660fd6442454 8bc6 c1e818 0bd0 }
            // n = 7, score = 100
            //   0f57c0               | xorps               xmm0, xmm0
            //   c1e208               | shl                 edx, 8
            //   0bd0                 | or                  edx, eax
            //   660fd6442454         | movq                qword ptr [esp + 0x54], xmm0
            //   8bc6                 | mov                 eax, esi
            //   c1e818               | shr                 eax, 0x18
            //   0bd0                 | or                  edx, eax

        $sequence_5 = { 8b4304 6a00 89442421 8d442418 6a0d 50 ff7308 }
            // n = 7, score = 100
            //   8b4304               | mov                 eax, dword ptr [ebx + 4]
            //   6a00                 | push                0
            //   89442421             | mov                 dword ptr [esp + 0x21], eax
            //   8d442418             | lea                 eax, [esp + 0x18]
            //   6a0d                 | push                0xd
            //   50                   | push                eax
            //   ff7308               | push                dword ptr [ebx + 8]

        $sequence_6 = { c3 57 8b7904 85ff 7404 8b01 8907 }
            // n = 7, score = 100
            //   c3                   | ret                 
            //   57                   | push                edi
            //   8b7904               | mov                 edi, dword ptr [ecx + 4]
            //   85ff                 | test                edi, edi
            //   7404                 | je                  6
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   8907                 | mov                 dword ptr [edi], eax

        $sequence_7 = { 68???????? 53 ffd7 5e 5d 5f }
            // n = 6, score = 100
            //   68????????           |                     
            //   53                   | push                ebx
            //   ffd7                 | call                edi
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   5f                   | pop                 edi

        $sequence_8 = { 8d7c242c 8bca 03fd 8bd9 c1e902 6601944612860000 }
            // n = 6, score = 100
            //   8d7c242c             | lea                 edi, [esp + 0x2c]
            //   8bca                 | mov                 ecx, edx
            //   03fd                 | add                 edi, ebp
            //   8bd9                 | mov                 ebx, ecx
            //   c1e902               | shr                 ecx, 2
            //   6601944612860000     | add                 word ptr [esi + eax*2 + 0x8612], dx

        $sequence_9 = { c1eb10 8b442410 c1e208 0fb6c0 0bd0 0fb6c3 }
            // n = 6, score = 100
            //   c1eb10               | shr                 ebx, 0x10
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   c1e208               | shl                 edx, 8
            //   0fb6c0               | movzx               eax, al
            //   0bd0                 | or                  edx, eax
            //   0fb6c3               | movzx               eax, bl

    condition:
        7 of them and filesize < 303104
}