rule win_kgh_spy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.kgh_spy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.kgh_spy"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4889442448 48c7442430ffffffff 48ff442430 488b442448 488b4c2430 803c0800 75eb }
            // n = 7, score = 100
            //   4889442448           | mov                 eax, 0x2000
            //   48c7442430ffffffff     | mov    edx, eax
            //   48ff442430           | dec                 eax
            //   488b442448           | cmp                 dword ptr [esp + 0x40], 0
            //   488b4c2430           | je                  0xbd1
            //   803c0800             | dec                 eax
            //   75eb                 | mov                 eax, dword ptr [esp + 0x40]

        $sequence_1 = { e8???????? eb40 4c8d35b7910000 488b0d???????? e9???????? 4c8d35b4910000 488b0d???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   eb40                 | xor                 al, al
            //   4c8d35b7910000       | mov                 eax, dword ptr [esp + 0x7c]
            //   488b0d????????       |                     
            //   e9????????           |                     
            //   4c8d35b4910000       | mov                 ecx, dword ptr [esp + 0x64]
            //   488b0d????????       |                     

        $sequence_2 = { 32c0 e9???????? 488d442460 4889442448 }
            // n = 4, score = 100
            //   32c0                 | mov                 eax, dword ptr [esp + 0x20]
            //   e9????????           |                     
            //   488d442460           | movzx               eax, word ptr [esp + 0x28]
            //   4889442448           | cmp                 eax, 6

        $sequence_3 = { 4889442428 4c894c2420 4d8bc8 4c8bc2 488bd1 488d0dcd0d0000 }
            // n = 6, score = 100
            //   4889442428           | mov                 eax, dword ptr [esp + 0x78]
            //   4c894c2420           | mov                 eax, ebp
            //   4d8bc8               | dec                 ebp
            //   4c8bc2               | lea                 ecx, [esp + 0x10]
            //   488bd1               | dec                 esp
            //   488d0dcd0d0000       | lea                 ebx, [eax + eax*2]

        $sequence_4 = { ff15???????? c744243041000000 eb0a 8b442430 ffc0 89442430 837c24305b }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   c744243041000000     | movzx               eax, byte ptr [esp + 0x41]
            //   eb0a                 | test                eax, eax
            //   8b442430             | mov                 byte ptr [esp + 0x480], 0
            //   ffc0                 | dec                 eax
            //   89442430             | lea                 eax, [esp + 0x481]
            //   837c24305b           | dec                 eax

        $sequence_5 = { 488b8c24a0000000 ff15???????? 89442468 8b442468 8bc8 e8???????? 48898424d8000000 }
            // n = 7, score = 100
            //   488b8c24a0000000     | mov                 eax, ecx
            //   ff15????????         |                     
            //   89442468             | mov                 ecx, dword ptr [esp + 0x20]
            //   8b442468             | shl                 ecx, 2
            //   8bc8                 | dec                 eax
            //   e8????????           |                     
            //   48898424d8000000     | mov                 eax, dword ptr [esp + 0x30]

        $sequence_6 = { 48c744242000000000 4c8b4c2478 448b442440 488b542450 488b4c2448 }
            // n = 5, score = 100
            //   48c744242000000000     | jne    0x67e
            //   4c8b4c2478           | xor                 al, al
            //   448b442440           | dec                 eax
            //   488b542450           | lea                 ecx, [0xec9d]
            //   488b4c2448           | jne                 0x689

        $sequence_7 = { ff15???????? 4889442460 48837c2460ff 7507 32c0 }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   4889442460           | dec                 eax
            //   48837c2460ff         | mov                 edx, dword ptr [esp + 0x58]
            //   7507                 | cmp                 byte ptr [ecx + edx], 0
            //   32c0                 | dec                 eax

        $sequence_8 = { 813850450000 7526 488b442438 83b88400000001 7218 b808000000 486bc000 }
            // n = 7, score = 100
            //   813850450000         | inc                 ecx
            //   7526                 | mov                 eax, 6
            //   488b442438           | dec                 eax
            //   83b88400000001       | lea                 edx, [0xa3b4]
            //   7218                 | dec                 eax
            //   b808000000           | cmp                 dword ptr [eax - 0x10], edx
            //   486bc000             | je                  0x5ff

        $sequence_9 = { 4c8d351a920000 488bfb 83e31f 48c1ff05 }
            // n = 4, score = 100
            //   4c8d351a920000       | mov                 al, 1
            //   488bfb               | dec                 eax
            //   83e31f               | mov                 ecx, dword ptr [esp + 0x68]
            //   48c1ff05             | dec                 eax

    condition:
        7 of them and filesize < 207872
}