rule win_killav_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.killav."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.killav"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b049d70ba4300 f644012801 0f8487000000 817d10ffffff7f }
            // n = 4, score = 200
            //   8b049d70ba4300       | mov                 eax, dword ptr [ebx*4 + 0x43ba70]
            //   f644012801           | test                byte ptr [ecx + eax + 0x28], 1
            //   0f8487000000         | je                  0x8d
            //   817d10ffffff7f       | cmp                 dword ptr [ebp + 0x10], 0x7fffffff

        $sequence_1 = { c705????????a0a74300 e8???????? 68???????? 50 }
            // n = 4, score = 200
            //   c705????????a0a74300     |     
            //   e8????????           |                     
            //   68????????           |                     
            //   50                   | push                eax

        $sequence_2 = { 8d45f4 64a300000000 8bc1 8945e8 817804ffffff07 8b08 8b7d08 }
            // n = 7, score = 200
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   8bc1                 | mov                 eax, ecx
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   817804ffffff07       | cmp                 dword ptr [eax + 4], 0x7ffffff
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]

        $sequence_3 = { ff34f518054300 ff7508 e8???????? 83c40c }
            // n = 4, score = 200
            //   ff34f518054300       | push                dword ptr [esi*8 + 0x430518]
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_4 = { 6bc838 894de0 8b049d70ba4300 f644012801 0f8487000000 817d10ffffff7f }
            // n = 6, score = 200
            //   6bc838               | imul                ecx, eax, 0x38
            //   894de0               | mov                 dword ptr [ebp - 0x20], ecx
            //   8b049d70ba4300       | mov                 eax, dword ptr [ebx*4 + 0x43ba70]
            //   f644012801           | test                byte ptr [ecx + eax + 0x28], 1
            //   0f8487000000         | je                  0x8d
            //   817d10ffffff7f       | cmp                 dword ptr [ebp + 0x10], 0x7fffffff

        $sequence_5 = { 7603 6a26 58 0fb60c855ed34200 0fb634855fd34200 8bf9 898598f8ffff }
            // n = 7, score = 200
            //   7603                 | jbe                 5
            //   6a26                 | push                0x26
            //   58                   | pop                 eax
            //   0fb60c855ed34200     | movzx               ecx, byte ptr [eax*4 + 0x42d35e]
            //   0fb634855fd34200     | movzx               esi, byte ptr [eax*4 + 0x42d35f]
            //   8bf9                 | mov                 edi, ecx
            //   898598f8ffff         | mov                 dword ptr [ebp - 0x768], eax

        $sequence_6 = { 8945ec 83c001 0f92c1 f7d9 0bc8 81f9ffffff7f }
            // n = 6, score = 200
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   83c001               | add                 eax, 1
            //   0f92c1               | setb                cl
            //   f7d9                 | neg                 ecx
            //   0bc8                 | or                  ecx, eax
            //   81f9ffffff7f         | cmp                 ecx, 0x7fffffff

        $sequence_7 = { c745ec07000000 668945d8 e8???????? 8d45d8 c645fc2a 50 8d4dd0 }
            // n = 7, score = 200
            //   c745ec07000000       | mov                 dword ptr [ebp - 0x14], 7
            //   668945d8             | mov                 word ptr [ebp - 0x28], ax
            //   e8????????           |                     
            //   8d45d8               | lea                 eax, [ebp - 0x28]
            //   c645fc2a             | mov                 byte ptr [ebp - 4], 0x2a
            //   50                   | push                eax
            //   8d4dd0               | lea                 ecx, [ebp - 0x30]

        $sequence_8 = { c745ec07000000 668945d8 e8???????? 8d45d8 c645fc33 50 8d4dd0 }
            // n = 7, score = 200
            //   c745ec07000000       | mov                 dword ptr [ebp - 0x14], 7
            //   668945d8             | mov                 word ptr [ebp - 0x28], ax
            //   e8????????           |                     
            //   8d45d8               | lea                 eax, [ebp - 0x28]
            //   c645fc33             | mov                 byte ptr [ebp - 4], 0x33
            //   50                   | push                eax
            //   8d4dd0               | lea                 ecx, [ebp - 0x30]

        $sequence_9 = { 8b04bd70ba4300 834c0318ff 33c0 eb16 e8???????? }
            // n = 5, score = 200
            //   8b04bd70ba4300       | mov                 eax, dword ptr [edi*4 + 0x43ba70]
            //   834c0318ff           | or                  dword ptr [ebx + eax + 0x18], 0xffffffff
            //   33c0                 | xor                 eax, eax
            //   eb16                 | jmp                 0x18
            //   e8????????           |                     

    condition:
        7 of them and filesize < 517120
}