rule win_kronos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.kronos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.kronos"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0fb706 8bd8 81e300f00000 81fb00300000 750e 8b5d08 }
            // n = 6, score = 2800
            //   0fb706               | movzx               eax, word ptr [esi]
            //   8bd8                 | mov                 ebx, eax
            //   81e300f00000         | and                 ebx, 0xf000
            //   81fb00300000         | cmp                 ebx, 0x3000
            //   750e                 | jne                 0x10
            //   8b5d08               | mov                 ebx, dword ptr [ebp + 8]

        $sequence_1 = { 0fb70c46 66ff444da4 8d4c4da4 40 }
            // n = 4, score = 2800
            //   0fb70c46             | movzx               ecx, word ptr [esi + eax*2]
            //   66ff444da4           | inc                 word ptr [ebp + ecx*2 - 0x5c]
            //   8d4c4da4             | lea                 ecx, [ebp + ecx*2 - 0x5c]
            //   40                   | inc                 eax

        $sequence_2 = { 0fb709 66394808 7417 8b00 }
            // n = 4, score = 2800
            //   0fb709               | movzx               ecx, word ptr [ecx]
            //   66394808             | cmp                 word ptr [eax + 8], cx
            //   7417                 | je                  0x19
            //   8b00                 | mov                 eax, dword ptr [eax]

        $sequence_3 = { 50 8d85d8fdffff 50 e8???????? 59 59 a3???????? }
            // n = 7, score = 2800
            //   50                   | push                eax
            //   8d85d8fdffff         | lea                 eax, [ebp - 0x228]
            //   50                   | push                eax
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   a3????????           |                     

        $sequence_4 = { 33db 897dfc 897df8 897df0 897df4 397d08 0f84a7000000 }
            // n = 7, score = 2800
            //   33db                 | xor                 ebx, ebx
            //   897dfc               | mov                 dword ptr [ebp - 4], edi
            //   897df8               | mov                 dword ptr [ebp - 8], edi
            //   897df0               | mov                 dword ptr [ebp - 0x10], edi
            //   897df4               | mov                 dword ptr [ebp - 0xc], edi
            //   397d08               | cmp                 dword ptr [ebp + 8], edi
            //   0f84a7000000         | je                  0xad

        $sequence_5 = { 33db 8d443818 663b4f06 0f8395000000 56 }
            // n = 5, score = 2800
            //   33db                 | xor                 ebx, ebx
            //   8d443818             | lea                 eax, [eax + edi + 0x18]
            //   663b4f06             | cmp                 cx, word ptr [edi + 6]
            //   0f8395000000         | jae                 0x9b
            //   56                   | push                esi

        $sequence_6 = { 0fb70c51 8b3488 8d45e0 50 }
            // n = 4, score = 2800
            //   0fb70c51             | movzx               ecx, word ptr [ecx + edx*2]
            //   8b3488               | mov                 esi, dword ptr [eax + ecx*4]
            //   8d45e0               | lea                 eax, [ebp - 0x20]
            //   50                   | push                eax

        $sequence_7 = { 50 8d85d8fdffff 6803010000 50 e8???????? 83c418 }
            // n = 6, score = 2800
            //   50                   | push                eax
            //   8d85d8fdffff         | lea                 eax, [ebp - 0x228]
            //   6803010000           | push                0x103
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18

    condition:
        7 of them and filesize < 1302528
}