rule win_ksl0t_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.ksl0t."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ksl0t"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? b9ff000000 e8???????? 488bfb 4803ff 4c8d2df17a0000 }
            // n = 6, score = 200
            //   e8????????           |                     
            //   b9ff000000           | lea                 ecx, [esp + 0x3b0]
            //   e8????????           |                     
            //   488bfb               | mov                 edx, 0xf
            //   4803ff               | dec                 eax
            //   4c8d2df17a0000       | lea                 ecx, [esp + 0x180]

        $sequence_1 = { 85c0 741d 8b54240c 52 8d442404 50 ff15???????? }
            // n = 7, score = 200
            //   85c0                 | test                eax, eax
            //   741d                 | je                  0x1f
            //   8b54240c             | mov                 edx, dword ptr [esp + 0xc]
            //   52                   | push                edx
            //   8d442404             | lea                 eax, [esp + 4]
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_2 = { ff15???????? 8d9500090000 52 ff15???????? 03c0 50 }
            // n = 6, score = 200
            //   ff15????????         |                     
            //   8d9500090000         | lea                 edx, [ebp + 0x900]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   03c0                 | add                 eax, eax
            //   50                   | push                eax

        $sequence_3 = { 57 8b55dc 52 ff15???????? 57 }
            // n = 5, score = 200
            //   57                   | push                edi
            //   8b55dc               | mov                 edx, dword ptr [ebp - 0x24]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   57                   | push                edi

        $sequence_4 = { 8d8d60060000 51 ff15???????? e9???????? }
            // n = 4, score = 200
            //   8d8d60060000         | lea                 ecx, [ebp + 0x660]
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   e9????????           |                     

        $sequence_5 = { c68424f900000002 c68424fa00000055 c644245813 c64424593c c644245a3b c644245b31 c644245c13 }
            // n = 7, score = 200
            //   c68424f900000002     | mov                 byte ptr [esp + 0x194], 0x18
            //   c68424fa00000055     | mov                 byte ptr [esp + 0x195], 0x20
            //   c644245813           | mov                 byte ptr [esp + 0x196], 0x21
            //   c64424593c           | mov                 ecx, 0xff
            //   c644245a3b           | dec                 eax
            //   c644245b31           | mov                 edi, ebx
            //   c644245c13           | dec                 eax

        $sequence_6 = { 448b8424a4140000 488d1586d20000 488d8c24a0100000 ff15???????? eb4e 66ba5c00 }
            // n = 6, score = 200
            //   448b8424a4140000     | dec                 eax
            //   488d1586d20000       | add                 edx, 0x15c
            //   488d8c24a0100000     | inc                 ecx
            //   ff15????????         |                     
            //   eb4e                 | mov                 eax, 4
            //   66ba5c00             | inc                 esp

        $sequence_7 = { 8d45f0 64a300000000 8965e8 c745fc00000000 6a01 }
            // n = 5, score = 200
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   8965e8               | mov                 dword ptr [ebp - 0x18], esp
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   6a01                 | push                1

        $sequence_8 = { 8bac2438030000 b23a 56 b321 8bf1 }
            // n = 5, score = 200
            //   8bac2438030000       | mov                 ebp, dword ptr [esp + 0x338]
            //   b23a                 | mov                 dl, 0x3a
            //   56                   | push                esi
            //   b321                 | mov                 bl, 0x21
            //   8bf1                 | mov                 esi, ecx

        $sequence_9 = { c68424090300003a c684240a03000006 c684240b0300002c c684240c03000026 c684240d03000021 }
            // n = 5, score = 200
            //   c68424090300003a     | mov                 eax, dword ptr [esp + 0x14a4]
            //   c684240a03000006     | dec                 eax
            //   c684240b0300002c     | lea                 edx, [0xd286]
            //   c684240c03000026     | dec                 eax
            //   c684240d03000021     | lea                 ecx, [esp + 0x10a0]

        $sequence_10 = { 488d8c24b0030000 e8???????? ba0f000000 488d8c2480010000 e8???????? }
            // n = 5, score = 200
            //   488d8c24b0030000     | jmp                 0x5f
            //   e8????????           |                     
            //   ba0f000000           | mov                 dx, 0x5c
            //   488d8c2480010000     | mov                 byte ptr [esp + 0x309], 0x3a
            //   e8????????           |                     

        $sequence_11 = { 488d0d47e30000 ff15???????? e9???????? 488d1575c00000 4881c25c010000 41b804000000 }
            // n = 6, score = 200
            //   488d0d47e30000       | dec                 eax
            //   ff15????????         |                     
            //   e9????????           |                     
            //   488d1575c00000       | lea                 ecx, [0xe347]
            //   4881c25c010000       | dec                 eax
            //   41b804000000         | lea                 edx, [0xc075]

        $sequence_12 = { 72f3 33c0 90 308c048c000000 40 83f80c }
            // n = 6, score = 200
            //   72f3                 | jb                  0xfffffff5
            //   33c0                 | xor                 eax, eax
            //   90                   | nop                 
            //   308c048c000000       | xor                 byte ptr [esp + eax + 0x8c], cl
            //   40                   | inc                 eax
            //   83f80c               | cmp                 eax, 0xc

        $sequence_13 = { c684242602000036 c684242702000014 c684242802000031 c684242902000031 }
            // n = 4, score = 200
            //   c684242602000036     | add                 edi, edi
            //   c684242702000014     | dec                 esp
            //   c684242802000031     | lea                 ebp, [0x7af1]
            //   c684242902000031     | dec                 eax

        $sequence_14 = { 0f8557ffffff b928000000 bf???????? bb???????? bd???????? b8???????? 2bf9 }
            // n = 7, score = 200
            //   0f8557ffffff         | jne                 0xffffff5d
            //   b928000000           | mov                 ecx, 0x28
            //   bf????????           |                     
            //   bb????????           |                     
            //   bd????????           |                     
            //   b8????????           |                     
            //   2bf9                 | sub                 edi, ecx

        $sequence_15 = { c684249201000030 c68424930100003b c684249401000018 c684249501000020 c684249601000021 }
            // n = 5, score = 200
            //   c684249201000030     | mov                 byte ptr [esp + 0x30a], 6
            //   c68424930100003b     | mov                 byte ptr [esp + 0x30b], 0x2c
            //   c684249401000018     | mov                 byte ptr [esp + 0x30c], 0x26
            //   c684249501000020     | mov                 byte ptr [esp + 0x30d], 0x21
            //   c684249601000021     | dec                 eax

    condition:
        7 of them and filesize < 196608
}