rule win_kurton_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.kurton."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.kurton"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33d2 f7750c ebe7 55 8bec 53 56 }
            // n = 7, score = 100
            //   33d2                 | xor                 edx, edx
            //   f7750c               | div                 dword ptr [ebp + 0xc]
            //   ebe7                 | jmp                 0xffffffe9
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   53                   | push                ebx
            //   56                   | push                esi

        $sequence_1 = { 51 ffd6 8b3d???????? 8d542428 52 ffd7 }
            // n = 6, score = 100
            //   51                   | push                ecx
            //   ffd6                 | call                esi
            //   8b3d????????         |                     
            //   8d542428             | lea                 edx, [esp + 0x28]
            //   52                   | push                edx
            //   ffd7                 | call                edi

        $sequence_2 = { 8bc6 83e61f c1f805 59 8b0485a05b0210 8d0cf6 8064880400 }
            // n = 7, score = 100
            //   8bc6                 | mov                 eax, esi
            //   83e61f               | and                 esi, 0x1f
            //   c1f805               | sar                 eax, 5
            //   59                   | pop                 ecx
            //   8b0485a05b0210       | mov                 eax, dword ptr [eax*4 + 0x10025ba0]
            //   8d0cf6               | lea                 ecx, [esi + esi*8]
            //   8064880400           | and                 byte ptr [eax + ecx*4 + 4], 0

        $sequence_3 = { 6a03 8d542418 68???????? 52 50 e8???????? 8b8c2438010000 }
            // n = 7, score = 100
            //   6a03                 | push                3
            //   8d542418             | lea                 edx, [esp + 0x18]
            //   68????????           |                     
            //   52                   | push                edx
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b8c2438010000       | mov                 ecx, dword ptr [esp + 0x138]

        $sequence_4 = { 53 52 53 53 6a16 50 }
            // n = 6, score = 100
            //   53                   | push                ebx
            //   52                   | push                edx
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   6a16                 | push                0x16
            //   50                   | push                eax

        $sequence_5 = { 52 53 68???????? 50 c745bcf4010000 ff15???????? }
            // n = 6, score = 100
            //   52                   | push                edx
            //   53                   | push                ebx
            //   68????????           |                     
            //   50                   | push                eax
            //   c745bcf4010000       | mov                 dword ptr [ebp - 0x44], 0x1f4
            //   ff15????????         |                     

        $sequence_6 = { 6a00 6a00 51 e8???????? 83c410 c20400 }
            // n = 6, score = 100
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   c20400               | ret                 4

        $sequence_7 = { 8079ff00 0f8547ffffff 8bc6 8088e15d021008 40 3dff000000 72f1 }
            // n = 7, score = 100
            //   8079ff00             | cmp                 byte ptr [ecx - 1], 0
            //   0f8547ffffff         | jne                 0xffffff4d
            //   8bc6                 | mov                 eax, esi
            //   8088e15d021008       | or                  byte ptr [eax + 0x10025de1], 8
            //   40                   | inc                 eax
            //   3dff000000           | cmp                 eax, 0xff
            //   72f1                 | jb                  0xfffffff3

        $sequence_8 = { ff15???????? 85f6 7434 8d4e08 51 ff15???????? 85c0 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   85f6                 | test                esi, esi
            //   7434                 | je                  0x36
            //   8d4e08               | lea                 ecx, [esi + 8]
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_9 = { f7d1 2bf9 8d94245d010000 8bc1 8bf7 8bfa c1e902 }
            // n = 7, score = 100
            //   f7d1                 | not                 ecx
            //   2bf9                 | sub                 edi, ecx
            //   8d94245d010000       | lea                 edx, [esp + 0x15d]
            //   8bc1                 | mov                 eax, ecx
            //   8bf7                 | mov                 esi, edi
            //   8bfa                 | mov                 edi, edx
            //   c1e902               | shr                 ecx, 2

    condition:
        7 of them and filesize < 344064
}