rule win_lambload_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.lambload."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lambload"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 83c408 85c0 7510 8b442414 c780a400000010260310 eb67 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   85c0                 | test                eax, eax
            //   7510                 | jne                 0x12
            //   8b442414             | mov                 eax, dword ptr [esp + 0x14]
            //   c780a400000010260310     | mov    dword ptr [eax + 0xa4], 0x10032610
            //   eb67                 | jmp                 0x69

        $sequence_1 = { 33c9 0fbe9930670610 3bfb 7408 }
            // n = 4, score = 100
            //   33c9                 | xor                 ecx, ecx
            //   0fbe9930670610       | movsx               ebx, byte ptr [ecx + 0x10066730]
            //   3bfb                 | cmp                 edi, ebx
            //   7408                 | je                  0xa

        $sequence_2 = { 5b 3bfb 7d1c 2bdf }
            // n = 4, score = 100
            //   5b                   | pop                 ebx
            //   3bfb                 | cmp                 edi, ebx
            //   7d1c                 | jge                 0x1e
            //   2bdf                 | sub                 ebx, edi

        $sequence_3 = { 8b6c2424 83c408 3be8 7e02 8be8 }
            // n = 5, score = 100
            //   8b6c2424             | mov                 ebp, dword ptr [esp + 0x24]
            //   83c408               | add                 esp, 8
            //   3be8                 | cmp                 ebp, eax
            //   7e02                 | jle                 4
            //   8be8                 | mov                 ebp, eax

        $sequence_4 = { 85db 56 751a 6a62 68???????? }
            // n = 5, score = 100
            //   85db                 | test                ebx, ebx
            //   56                   | push                esi
            //   751a                 | jne                 0x1c
            //   6a62                 | push                0x62
            //   68????????           |                     

        $sequence_5 = { 50 e8???????? ff33 ffb5f0f5ffff }
            // n = 4, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   ff33                 | push                dword ptr [ebx]
            //   ffb5f0f5ffff         | push                dword ptr [ebp - 0xa10]

        $sequence_6 = { eb16 8d8be8330710 6a0a 8d542424 51 52 e8???????? }
            // n = 7, score = 100
            //   eb16                 | jmp                 0x18
            //   8d8be8330710         | lea                 ecx, [ebx + 0x100733e8]
            //   6a0a                 | push                0xa
            //   8d542424             | lea                 edx, [esp + 0x24]
            //   51                   | push                ecx
            //   52                   | push                edx
            //   e8????????           |                     

        $sequence_7 = { 75d7 6a03 5b 3bfb 7d1c 2bdf }
            // n = 6, score = 100
            //   75d7                 | jne                 0xffffffd9
            //   6a03                 | push                3
            //   5b                   | pop                 ebx
            //   3bfb                 | cmp                 edi, ebx
            //   7d1c                 | jge                 0x1e
            //   2bdf                 | sub                 ebx, edi

        $sequence_8 = { 85c0 7529 0fb78c05ecfbffff 66898c05f4fdffff 83c002 663bce }
            // n = 6, score = 100
            //   85c0                 | test                eax, eax
            //   7529                 | jne                 0x2b
            //   0fb78c05ecfbffff     | movzx               ecx, word ptr [ebp + eax - 0x414]
            //   66898c05f4fdffff     | mov                 word ptr [ebp + eax - 0x20c], cx
            //   83c002               | add                 eax, 2
            //   663bce               | cmp                 cx, si

        $sequence_9 = { c1e106 030c9500490710 eb05 b9???????? f641247f 75a2 83f8ff }
            // n = 7, score = 100
            //   c1e106               | shl                 ecx, 6
            //   030c9500490710       | add                 ecx, dword ptr [edx*4 + 0x10074900]
            //   eb05                 | jmp                 7
            //   b9????????           |                     
            //   f641247f             | test                byte ptr [ecx + 0x24], 0x7f
            //   75a2                 | jne                 0xffffffa4
            //   83f8ff               | cmp                 eax, -1

    condition:
        7 of them and filesize < 1039360
}