rule win_latrodectus_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.latrodectus."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.latrodectus"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b442420 4883c002 488bc8 e8???????? 4889442428 }
            // n = 5, score = 3800
            //   8b442420             | dec                 eax
            //   4883c002             | mov                 dword ptr [esp + 0x238], eax
            //   488bc8               | mov                 dword ptr [esp + 0x240], 0x3872beb9
            //   e8????????           |                     
            //   4889442428           | dec                 eax

        $sequence_1 = { 4889842438010000 4c8d442430 488b942430010000 488b8c2438010000 }
            // n = 4, score = 3800
            //   4889842438010000     | mov                 dword ptr [esp + 0x48], eax
            //   4c8d442430           | dec                 eax
            //   488b942430010000     | cmp                 dword ptr [esp + 0x48], 0
            //   488b8c2438010000     | jne                 0x12b1

        $sequence_2 = { 85c0 742b e8???????? 85c0 7422 e8???????? }
            // n = 6, score = 3800
            //   85c0                 | lea                 eax, [0x6e6f]
            //   742b                 | dec                 eax
            //   e8????????           |                     
            //   85c0                 | mov                 dword ptr [esp + 0x88], eax
            //   7422                 | mov                 dword ptr [esp + 0x90], 0x2822fbb7
            //   e8????????           |                     

        $sequence_3 = { 4c8b8c24a0000000 450fb74904 6641c1c908 450fb7c9 4c8b9424a0000000 450fb712 6641c1ca08 }
            // n = 7, score = 3800
            //   4c8b8c24a0000000     | je                  0x6fa
            //   450fb74904           | dec                 eax
            //   6641c1c908           | lea                 eax, [esp + 0x160]
            //   450fb7c9             | dec                 eax
            //   4c8b9424a0000000     | mov                 dword ptr [esp + 0x40], eax
            //   450fb712             | dec                 eax
            //   6641c1ca08           | lea                 ecx, [0xc118]

        $sequence_4 = { ff15???????? 8b4c2420 0fafc8 8bc1 89442424 8b4c2424 }
            // n = 6, score = 3800
            //   ff15????????         |                     
            //   8b4c2420             | dec                 eax
            //   0fafc8               | sub                 esp, 0x88
            //   8bc1                 | mov                 dword ptr [esp + 0x30], 0x7a0a041b
            //   89442424             | dec                 eax
            //   8b4c2424             | lea                 eax, [0x72f6]

        $sequence_5 = { ba50020000 488d8c2490000000 e8???????? 488d942490000000 488b4c2420 ff15???????? 4889442430 }
            // n = 7, score = 3800
            //   ba50020000           | lea                 ecx, [0xeef3]
            //   488d8c2490000000     | dec                 eax
            //   e8????????           |                     
            //   488d942490000000     | test                eax, eax
            //   488b4c2420           | je                  0x1c53
            //   ff15????????         |                     
            //   4889442430           | dec                 eax

        $sequence_6 = { eb31 8b442448 8bd0 488b442440 488b08 e8???????? }
            // n = 6, score = 3800
            //   eb31                 | mov                 dword ptr [esp + 0x20], eax
            //   8b442448             | inc                 esp
            //   8bd0                 | mov                 eax, dword ptr [esp + 0x20]
            //   488b442440           | dec                 eax
            //   488b08               | mov                 edx, dword ptr [esp + 0x40]
            //   e8????????           |                     

        $sequence_7 = { eb1e 488b8424b8000000 8b4c2444 8908 488b8424c8000000 0fb74c2454 668908 }
            // n = 7, score = 3800
            //   eb1e                 | dec                 eax
            //   488b8424b8000000     | mov                 eax, dword ptr [esp + 0x188]
            //   8b4c2444             | jmp                 0x3ef
            //   8908                 | dec                 eax
            //   488b8424c8000000     | lea                 eax, [esp + 0x1b0]
            //   0fb74c2454           | dec                 eax
            //   668908               | mov                 dword ptr [esp + 0x178], eax

        $sequence_8 = { 488b442430 8b401c 488b4c2470 4803c8 488bc1 488b4c2450 }
            // n = 6, score = 3800
            //   488b442430           | dec                 eax
            //   8b401c               | test                eax, eax
            //   488b4c2470           | je                  0x125e
            //   4803c8               | dec                 eax
            //   488bc1               | lea                 eax, [esp + 0xb0]
            //   488b4c2450           | dec                 eax

        $sequence_9 = { 8b442428 390424 732f 8b442408 c1e808 8b0c24 488b542420 }
            // n = 7, score = 3800
            //   8b442428             | mov                 dword ptr [esp + 0xe0], eax
            //   390424               | xor                 eax, eax
            //   732f                 | cmp                 eax, 1
            //   8b442408             | dec                 eax
            //   c1e808               | lea                 eax, [esp + 0x1d0]
            //   8b0c24               | dec                 eax
            //   488b542420           | mov                 dword ptr [esp + 0x100], eax

    condition:
        7 of them and filesize < 173056
}