rule win_laturo_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.laturo."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.laturo"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4c8d0568000000 488d15d9380100 488d0de2380100 e8???????? 4c8d0d6e730100 4c8d0567010000 }
            // n = 6, score = 200
            //   4c8d0568000000       | mov                 esp, ecx
            //   488d15d9380100       | dec                 ecx
            //   488d0de2380100       | mov                 ebp, eax
            //   e8????????           |                     
            //   4c8d0d6e730100       | dec                 esp
            //   4c8d0567010000       | mov                 ebp, edx

        $sequence_1 = { 0f8592000000 0fb6442420 4883f802 7332 }
            // n = 4, score = 200
            //   0f8592000000         | mov                 ecx, 6
            //   0fb6442420           | dec                 esp
            //   4883f802             | lea                 eax, [0x8693]
            //   7332                 | jne                 0x98

        $sequence_2 = { 4c8d0db0860000 8bf9 488d15a7860000 b906000000 4c8d0593860000 }
            // n = 5, score = 200
            //   4c8d0db0860000       | dec                 esp
            //   8bf9                 | lea                 ecx, [0x86b0]
            //   488d15a7860000       | mov                 edi, ecx
            //   b906000000           | dec                 eax
            //   4c8d0593860000       | lea                 edx, [0x86a7]

        $sequence_3 = { 750b 0fb6442406 d0e0 88442406 0fb6442405 }
            // n = 5, score = 200
            //   750b                 | movzx               eax, byte ptr [esp + 0x20]
            //   0fb6442406           | dec                 eax
            //   d0e0                 | cmp                 eax, 2
            //   88442406             | jae                 0x3d
            //   0fb6442405           | jne                 0xd

        $sequence_4 = { 880424 0fb60424 89442448 488b442410 48ffc0 4889442410 }
            // n = 6, score = 200
            //   880424               | dec                 esp
            //   0fb60424             | lea                 eax, [0x68]
            //   89442448             | dec                 eax
            //   488b442410           | lea                 edx, [0x138d9]
            //   48ffc0               | dec                 eax
            //   4889442410           | lea                 ecx, [0x138e2]

        $sequence_5 = { 48034a10 488bf9 488b742478 8bc8 }
            // n = 4, score = 200
            //   48034a10             | dec                 ebx
            //   488bf9               | mov                 ecx, dword ptr [esi + edi*8 + 0x19fe8]
            //   488b742478           | dec                 eax
            //   8bc8                 | or                  edi, 0xffffffff

        $sequence_6 = { 488b442410 48ffc0 4889442410 0fb6442402 83e040 85c0 743d }
            // n = 7, score = 200
            //   488b442410           | dec                 esp
            //   48ffc0               | lea                 ecx, [0x1736e]
            //   4889442410           | dec                 esp
            //   0fb6442402           | lea                 eax, [0x167]
            //   83e040               | dec                 eax
            //   85c0                 | add                 ecx, dword ptr [edx + 0x10]
            //   743d                 | dec                 eax

        $sequence_7 = { 4d8be1 498be8 4c8bea 4b8b8cfee89f0100 4c8b15???????? 4883cfff }
            // n = 6, score = 200
            //   4d8be1               | movzx               eax, byte ptr [esp + 6]
            //   498be8               | shl                 al, 1
            //   4c8bea               | mov                 byte ptr [esp + 6], al
            //   4b8b8cfee89f0100     | movzx               eax, byte ptr [esp + 5]
            //   4c8b15????????       |                     
            //   4883cfff             | dec                 ebp

        $sequence_8 = { a1???????? 33d2 56 57 8bf9 8bf7 }
            // n = 6, score = 100
            //   a1????????           |                     
            //   33d2                 | xor                 edx, edx
            //   56                   | push                esi
            //   57                   | push                edi
            //   8bf9                 | mov                 edi, ecx
            //   8bf7                 | mov                 esi, edi

        $sequence_9 = { eb21 886a01 b002 eb1a 886a02 b020 }
            // n = 6, score = 100
            //   eb21                 | jmp                 0x23
            //   886a01               | mov                 byte ptr [edx + 1], ch
            //   b002                 | mov                 al, 2
            //   eb1a                 | jmp                 0x1c
            //   886a02               | mov                 byte ptr [edx + 2], ch
            //   b020                 | mov                 al, 0x20

        $sequence_10 = { 8b35???????? 8d45dc 6a1c 50 }
            // n = 4, score = 100
            //   8b35????????         |                     
            //   8d45dc               | lea                 eax, [ebp - 0x24]
            //   6a1c                 | push                0x1c
            //   50                   | push                eax

        $sequence_11 = { 80fb90 7405 80fbcc 7520 b801000000 3bd0 7610 }
            // n = 7, score = 100
            //   80fb90               | cmp                 bl, 0x90
            //   7405                 | je                  7
            //   80fbcc               | cmp                 bl, 0xcc
            //   7520                 | jne                 0x22
            //   b801000000           | mov                 eax, 1
            //   3bd0                 | cmp                 edx, eax
            //   7610                 | jbe                 0x12

        $sequence_12 = { 8b550c 83ec20 33c9 8bc1 3914c5f81b0110 7408 40 }
            // n = 7, score = 100
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   83ec20               | sub                 esp, 0x20
            //   33c9                 | xor                 ecx, ecx
            //   8bc1                 | mov                 eax, ecx
            //   3914c5f81b0110       | cmp                 dword ptr [eax*8 + 0x10011bf8], edx
            //   7408                 | je                  0xa
            //   40                   | inc                 eax

        $sequence_13 = { 0fb6c0 83e800 741f 83e801 }
            // n = 4, score = 100
            // 
            //   83e800               | sub                 eax, 0
            //   741f                 | je                  0x21
            //   83e801               | sub                 eax, 1

        $sequence_14 = { 814a1800100100 8a65fd eb0e 8a65fd }
            // n = 4, score = 100
            //   814a1800100100       | or                  dword ptr [edx + 0x18], 0x11000
            //   8a65fd               | mov                 ah, byte ptr [ebp - 3]
            //   eb0e                 | jmp                 0x10
            //   8a65fd               | mov                 ah, byte ptr [ebp - 3]

        $sequence_15 = { 56 57 ff15???????? 894514 85c0 784d 83ff05 }
            // n = 7, score = 100
            //   56                   | push                esi
            //   57                   | push                edi
            //   ff15????????         |                     
            //   894514               | mov                 dword ptr [ebp + 0x14], eax
            //   85c0                 | test                eax, eax
            //   784d                 | js                  0x4f
            //   83ff05               | cmp                 edi, 5

    condition:
        7 of them and filesize < 253952
}