rule win_leash_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.leash."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.leash"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d8c24fc150000 3b11 7514 8b442414 }
            // n = 4, score = 200
            //   8d8c24fc150000       | lea                 ecx, [esp + 0x15fc]
            //   3b11                 | cmp                 edx, dword ptr [ecx]
            //   7514                 | jne                 0x16
            //   8b442414             | mov                 eax, dword ptr [esp + 0x14]

        $sequence_1 = { 8d8e19080000 50 51 c706???????? 899e04080000 }
            // n = 5, score = 200
            //   8d8e19080000         | lea                 ecx, [esi + 0x819]
            //   50                   | push                eax
            //   51                   | push                ecx
            //   c706????????         |                     
            //   899e04080000         | mov                 dword ptr [esi + 0x804], ebx

        $sequence_2 = { c645fc0a e9???????? 8d4db8 e8???????? 3bc3 8945dc 0f8601020000 }
            // n = 7, score = 200
            //   c645fc0a             | mov                 byte ptr [ebp - 4], 0xa
            //   e9????????           |                     
            //   8d4db8               | lea                 ecx, [ebp - 0x48]
            //   e8????????           |                     
            //   3bc3                 | cmp                 eax, ebx
            //   8945dc               | mov                 dword ptr [ebp - 0x24], eax
            //   0f8601020000         | jbe                 0x207

        $sequence_3 = { 6a20 68???????? e8???????? 8b15???????? }
            // n = 4, score = 200
            //   6a20                 | push                0x20
            //   68????????           |                     
            //   e8????????           |                     
            //   8b15????????         |                     

        $sequence_4 = { 83c10e 894d18 eb1f 8b4514 83f810 7507 b80a000000 }
            // n = 7, score = 200
            //   83c10e               | add                 ecx, 0xe
            //   894d18               | mov                 dword ptr [ebp + 0x18], ecx
            //   eb1f                 | jmp                 0x21
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]
            //   83f810               | cmp                 eax, 0x10
            //   7507                 | jne                 9
            //   b80a000000           | mov                 eax, 0xa

        $sequence_5 = { e8???????? 8b4c2410 51 8b8b08080000 e8???????? 8d4c2410 c684240452000001 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]
            //   51                   | push                ecx
            //   8b8b08080000         | mov                 ecx, dword ptr [ebx + 0x808]
            //   e8????????           |                     
            //   8d4c2410             | lea                 ecx, [esp + 0x10]
            //   c684240452000001     | mov                 byte ptr [esp + 0x5204], 1

        $sequence_6 = { 85c0 0f85fb050000 668b15???????? b9ff000000 8dbc24fe350000 66899424fc350000 f3ab }
            // n = 7, score = 200
            //   85c0                 | test                eax, eax
            //   0f85fb050000         | jne                 0x601
            //   668b15????????       |                     
            //   b9ff000000           | mov                 ecx, 0xff
            //   8dbc24fe350000       | lea                 edi, [esp + 0x35fe]
            //   66899424fc350000     | mov                 word ptr [esp + 0x35fc], dx
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax

        $sequence_7 = { 8bf0 8bce e8???????? 8b542410 8bce 52 }
            // n = 6, score = 200
            //   8bf0                 | mov                 esi, eax
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   8b542410             | mov                 edx, dword ptr [esp + 0x10]
            //   8bce                 | mov                 ecx, esi
            //   52                   | push                edx

        $sequence_8 = { 8bca 8d959cfdffff 83e103 f3a4 bf???????? 83c9ff f2ae }
            // n = 7, score = 200
            //   8bca                 | mov                 ecx, edx
            //   8d959cfdffff         | lea                 edx, [ebp - 0x264]
            //   83e103               | and                 ecx, 3
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   bf????????           |                     
            //   83c9ff               | or                  ecx, 0xffffffff
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]

        $sequence_9 = { aa b9ff000000 33c0 8dbd5df5ffff 889d5cf5ffff f3ab }
            // n = 6, score = 200
            //   aa                   | stosb               byte ptr es:[edi], al
            //   b9ff000000           | mov                 ecx, 0xff
            //   33c0                 | xor                 eax, eax
            //   8dbd5df5ffff         | lea                 edi, [ebp - 0xaa3]
            //   889d5cf5ffff         | mov                 byte ptr [ebp - 0xaa4], bl
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax

    condition:
        7 of them and filesize < 761856
}