rule win_lightneuron_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.lightneuron."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lightneuron"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 410fafd5 0fafce 8bc2 c1e210 c1e810 4403d0 8bc1 }
            // n = 7, score = 100
            //   410fafd5             | dec                 eax
            //   0fafce               | cmp                 edx, 2
            //   8bc2                 | je                  0x4f5
            //   c1e210               | dec                 eax
            //   c1e810               | cmp                 edx, 4
            //   4403d0               | jne                 0x4f9
            //   8bc1                 | dec                 ecx

        $sequence_1 = { c1c108 33d1 4333949ed0ff0200 413354240c 83c3fe 0f8458010000 448bdb }
            // n = 7, score = 100
            //   c1c108               | ret                 
            //   33d1                 | dec                 ecx
            //   4333949ed0ff0200     | cmp                 edx, 5
            //   413354240c           | jl                  0x468
            //   83c3fe               | inc                 ecx
            //   0f8458010000         | movzx               eax, byte ptr [ebx + 2]
            //   448bdb               | inc                 ecx

        $sequence_2 = { 0f87aa010000 48895c2460 8d5ffd 48896c2468 85db 0f8e77010000 66666666660f1f840000000000 }
            // n = 7, score = 100
            //   0f87aa010000         | inc                 ebp
            //   48895c2460           | xor                 eax, dword ptr [esp + eax*4 + 0x3c270]
            //   8d5ffd               | inc                 ecx
            //   48896c2468           | movzx               eax, bl
            //   85db                 | inc                 ebp
            //   0f8e77010000         | xor                 edx, dword ptr [esp + eax*4 + 0x3be70]
            //   66666666660f1f840000000000     | inc    esp

        $sequence_3 = { 4c8be1 448d4210 488d4c2420 ffc6 c1e604 498be9 e8???????? }
            // n = 7, score = 100
            //   4c8be1               | dec                 ebp
            //   448d4210             | mov                 ebp, ecx
            //   488d4c2420           | inc                 ecx
            //   ffc6                 | mov                 ebp, eax
            //   c1e604               | dec                 eax
            //   498be9               | mov                 esi, edx
            //   e8????????           |                     

        $sequence_4 = { 4c897c2428 4533c9 44897c2420 488d0d2fe80200 4533c0 ba74270000 e8???????? }
            // n = 7, score = 100
            //   4c897c2428           | mov                 dword ptr [esp + 0x70], 0x18
            //   4533c9               | mov                 dword ptr [esp + 0x80], 1
            //   44897c2420           | dec                 esp
            //   488d0d2fe80200       | lea                 eax, [eax + ecx*4 - 4]
            //   4533c0               | nop                 word ptr [eax + eax]
            //   ba74270000           | inc                 ecx
            //   e8????????           |                     

        $sequence_5 = { 48896c2468 4885ed 7409 8b742450 e9???????? 83782804 757e }
            // n = 7, score = 100
            //   48896c2468           | test                eax, eax
            //   4885ed               | je                  0x69b
            //   7409                 | dec                 eax
            //   8b742450             | mov                 ecx, ebx
            //   e9????????           |                     
            //   83782804             | dec                 eax
            //   757e                 | cmovne              edx, eax

        $sequence_6 = { 4885c0 4c8d842480000000 498bcf 480f45d0 e8???????? 488b05???????? 4c8b05???????? }
            // n = 7, score = 100
            //   4885c0               | mov                 ebx, dword ptr [esp + 0x40]
            //   4c8d842480000000     | dec                 eax
            //   498bcf               | add                 esp, 0x20
            //   480f45d0             | pop                 esi
            //   e8????????           |                     
            //   488b05????????       |                     
            //   4c8b05????????       |                     

        $sequence_7 = { 41336c2408 418b9486d0f70200 410fb6c0 418b8c86d0f70200 c1ca08 410fb6c1 c1c110 }
            // n = 7, score = 100
            //   41336c2408           | mov                 dword ptr [esp + 0x28], eax
            //   418b9486d0f70200     | dec                 eax
            //   410fb6c0             | mov                 eax, dword ptr [esp + 0x128]
            //   418b8c86d0f70200     | dec                 eax
            //   c1ca08               | mov                 dword ptr [esp + 0x88], eax
            //   410fb6c1             | dec                 eax
            //   c1c110               | arpl                word ptr [esp + 0x138], cx

        $sequence_8 = { 48c78424a8000000ffffffff 48c78424b000000000000000 48c78424b800000001000000 48c78424c000000002000000 48c78424c800000003000000 33c0 83f801 }
            // n = 7, score = 100
            //   48c78424a8000000ffffffff     | dec    eax
            //   48c78424b000000000000000     | mov    dword ptr [esp + 0xe0], edx
            //   48c78424b800000001000000     | add    dword ptr [ecx], ebp
            //   48c78424c000000002000000     | xor    eax, eax
            //   48c78424c800000003000000     | cmp    dword ptr [ecx], ebp
            //   33c0                 | setb                al
            //   83f801               | dec                 esp

        $sequence_9 = { ffe1 488b4318 488d942480000000 41b802000000 0fb74808 888c2480000000 66c1e908 }
            // n = 7, score = 100
            //   ffe1                 | neg                 esp
            //   488b4318             | mov                 ebx, eax
            //   488d942480000000     | test                eax, eax
            //   41b802000000         | jne                 0x1fbf
            //   0fb74808             | dec                 eax
            //   888c2480000000       | mov                 ecx, dword ptr [esp + 0xa8]
            //   66c1e908             | inc                 ecx

    condition:
        7 of them and filesize < 573440
}