rule win_listrix_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.listrix."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.listrix"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d8dc0f5ffff 51 ffd3 85c0 7454 57 }
            // n = 6, score = 100
            //   8d8dc0f5ffff         | lea                 ecx, [ebp - 0xa40]
            //   51                   | push                ecx
            //   ffd3                 | call                ebx
            //   85c0                 | test                eax, eax
            //   7454                 | je                  0x56
            //   57                   | push                edi

        $sequence_1 = { 85f6 740d f68594f5ffff10 0f84ac010000 8b1d???????? 68???????? 8d85c0f5ffff }
            // n = 7, score = 100
            //   85f6                 | test                esi, esi
            //   740d                 | je                  0xf
            //   f68594f5ffff10       | test                byte ptr [ebp - 0xa6c], 0x10
            //   0f84ac010000         | je                  0x1b2
            //   8b1d????????         |                     
            //   68????????           |                     
            //   8d85c0f5ffff         | lea                 eax, [ebp - 0xa40]

        $sequence_2 = { 8d46ff 50 8b8584f5ffff 51 52 50 8d8df4fbffff }
            // n = 7, score = 100
            //   8d46ff               | lea                 eax, [esi - 1]
            //   50                   | push                eax
            //   8b8584f5ffff         | mov                 eax, dword ptr [ebp - 0xa7c]
            //   51                   | push                ecx
            //   52                   | push                edx
            //   50                   | push                eax
            //   8d8df4fbffff         | lea                 ecx, [ebp - 0x40c]

        $sequence_3 = { 8d85f4f7ffff 50 ff15???????? 8b7518 }
            // n = 4, score = 100
            //   8d85f4f7ffff         | lea                 eax, [ebp - 0x80c]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8b7518               | mov                 esi, dword ptr [ebp + 0x18]

        $sequence_4 = { 89b588f5ffff 397510 0f8e4c020000 57 8d85f4f7ffff 50 }
            // n = 6, score = 100
            //   89b588f5ffff         | mov                 dword ptr [ebp - 0xa78], esi
            //   397510               | cmp                 dword ptr [ebp + 0x10], esi
            //   0f8e4c020000         | jle                 0x252
            //   57                   | push                edi
            //   8d85f4f7ffff         | lea                 eax, [ebp - 0x80c]
            //   50                   | push                eax

        $sequence_5 = { 50 8d4c2470 51 c744242430794000 }
            // n = 4, score = 100
            //   50                   | push                eax
            //   8d4c2470             | lea                 ecx, [esp + 0x70]
            //   51                   | push                ecx
            //   c744242430794000     | mov                 dword ptr [esp + 0x24], 0x407930

        $sequence_6 = { c1e802 89442408 c744240c02000000 85c0 0f8408010000 }
            // n = 5, score = 100
            //   c1e802               | shr                 eax, 2
            //   89442408             | mov                 dword ptr [esp + 8], eax
            //   c744240c02000000     | mov                 dword ptr [esp + 0xc], 2
            //   85c0                 | test                eax, eax
            //   0f8408010000         | je                  0x10e

        $sequence_7 = { 8bc7 c1f805 c1e606 033485e0ad4000 8b45f8 8b00 }
            // n = 6, score = 100
            //   8bc7                 | mov                 eax, edi
            //   c1f805               | sar                 eax, 5
            //   c1e606               | shl                 esi, 6
            //   033485e0ad4000       | add                 esi, dword ptr [eax*4 + 0x40ade0]
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   8b00                 | mov                 eax, dword ptr [eax]

        $sequence_8 = { a1???????? c705????????cc274000 8935???????? a3???????? ff15???????? a3???????? }
            // n = 6, score = 100
            //   a1????????           |                     
            //   c705????????cc274000     |     
            //   8935????????         |                     
            //   a3????????           |                     
            //   ff15????????         |                     
            //   a3????????           |                     

        $sequence_9 = { 6a00 8d95e4f9ffff 52 ff15???????? 85c0 0f84bb000000 }
            // n = 6, score = 100
            //   6a00                 | push                0
            //   8d95e4f9ffff         | lea                 edx, [ebp - 0x61c]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f84bb000000         | je                  0xc1

    condition:
        7 of them and filesize < 106496
}