rule win_lock_pos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.lock_pos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lock_pos"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bec 8b4508 8b0d???????? 8b0481 }
            // n = 4, score = 400
            //   8bec                 | mov                 ebp, esp
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b0d????????         |                     
            //   8b0481               | mov                 eax, dword ptr [ecx + eax*4]

        $sequence_1 = { 8bec 837d0800 7704 33c0 }
            // n = 4, score = 400
            //   8bec                 | mov                 ebp, esp
            //   837d0800             | cmp                 dword ptr [ebp + 8], 0
            //   7704                 | ja                  6
            //   33c0                 | xor                 eax, eax

        $sequence_2 = { 6a00 6a23 6a00 ff15???????? 8d8df8fdffff }
            // n = 5, score = 300
            //   6a00                 | push                0
            //   6a23                 | push                0x23
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   8d8df8fdffff         | lea                 ecx, [ebp - 0x208]

        $sequence_3 = { 55 8bec 81eca4040000 56 }
            // n = 4, score = 300
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81eca4040000         | sub                 esp, 0x4a4
            //   56                   | push                esi

        $sequence_4 = { 8d85f8fdffff 50 6a00 6a00 6a23 }
            // n = 5, score = 300
            //   8d85f8fdffff         | lea                 eax, [ebp - 0x208]
            //   50                   | push                eax
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a23                 | push                0x23

        $sequence_5 = { 6a00 32db e8???????? 8bf8 59 59 85ff }
            // n = 7, score = 200
            //   6a00                 | push                0
            //   32db                 | xor                 bl, bl
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   85ff                 | test                edi, edi

        $sequence_6 = { 8b450c 85c0 740a 8b55f8 8911 8b4dfc 8908 }
            // n = 7, score = 200
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   85c0                 | test                eax, eax
            //   740a                 | je                  0xc
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   8911                 | mov                 dword ptr [ecx], edx
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   8908                 | mov                 dword ptr [eax], ecx

        $sequence_7 = { ff15???????? 85c0 7555 57 6a04 8d45e4 50 }
            // n = 7, score = 200
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7555                 | jne                 0x57
            //   57                   | push                edi
            //   6a04                 | push                4
            //   8d45e4               | lea                 eax, [ebp - 0x1c]
            //   50                   | push                eax

        $sequence_8 = { 8b4de4 034804 894de4 8b55f0 8b45f0 034204 8945f0 }
            // n = 7, score = 200
            //   8b4de4               | mov                 ecx, dword ptr [ebp - 0x1c]
            //   034804               | add                 ecx, dword ptr [eax + 4]
            //   894de4               | mov                 dword ptr [ebp - 0x1c], ecx
            //   8b55f0               | mov                 edx, dword ptr [ebp - 0x10]
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   034204               | add                 eax, dword ptr [edx + 4]
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax

        $sequence_9 = { 6a04 8b4508 50 8d4dec 51 e8???????? 83c40c }
            // n = 7, score = 200
            //   6a04                 | push                4
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   50                   | push                eax
            //   8d4dec               | lea                 ecx, [ebp - 0x14]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_10 = { 8908 837df400 740b 8b55f4 }
            // n = 4, score = 200
            //   8908                 | mov                 dword ptr [eax], ecx
            //   837df400             | cmp                 dword ptr [ebp - 0xc], 0
            //   740b                 | je                  0xd
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]

        $sequence_11 = { 837dfc00 7414 8b450c 50 8b4d08 51 }
            // n = 6, score = 200
            //   837dfc00             | cmp                 dword ptr [ebp - 4], 0
            //   7414                 | je                  0x16
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   50                   | push                eax
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   51                   | push                ecx

        $sequence_12 = { 8b45dc 83e801 8945dc 85d2 0f843a010000 8b4df4 668b11 }
            // n = 7, score = 200
            //   8b45dc               | mov                 eax, dword ptr [ebp - 0x24]
            //   83e801               | sub                 eax, 1
            //   8945dc               | mov                 dword ptr [ebp - 0x24], eax
            //   85d2                 | test                edx, edx
            //   0f843a010000         | je                  0x140
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   668b11               | mov                 dx, word ptr [ecx]

    condition:
        7 of them and filesize < 319488
}