rule win_lockfile_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.lockfile."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lockfile"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488bc3 eb02 33c0 488b5c2440 488b6c2448 488b742450 488b7c2458 }
            // n = 7, score = 200
            //   488bc3               | dec                 eax
            //   eb02                 | mov                 eax, edi
            //   33c0                 | dec                 eax
            //   488b5c2440           | mov                 ebx, dword ptr [esp + 0x60]
            //   488b6c2448           | dec                 eax
            //   488b742450           | mov                 ebp, dword ptr [esp + 0x68]
            //   488b7c2458           | dec                 eax

        $sequence_1 = { c6856401000069 c685650100003f c685660100003d c6856701000020 c685680100003f c6856901000029 c6856a0100003e }
            // n = 7, score = 200
            //   c6856401000069       | lea                 ecx, [edx + eax]
            //   c685650100003f       | dec                 ecx
            //   c685660100003d       | mov                 eax, ecx
            //   c6856701000020       | je                  0x16e3
            //   c685680100003f       | dec                 eax
            //   c6856901000029       | test                eax, eax
            //   c6856a0100003e       | je                  0x16cb

        $sequence_2 = { 740b 488b01 ba01000000 ff10 90 4c897dd8 488b4dc8 }
            // n = 7, score = 200
            //   740b                 | lea                 ecx, [eax + eax]
            //   488b01               | dec                 ecx
            //   ba01000000           | mov                 eax, dword ptr [ecx + 0x58]
            //   ff10                 | dec                 esp
            //   90                   | cmp                 eax, ecx
            //   4c897dd8             | dec                 ecx
            //   488b4dc8             | adc                 edi, 0

        $sequence_3 = { 4883ec20 488bd9 ba60000000 b958000000 488b4360 48394358 0f42d1 }
            // n = 7, score = 200
            //   4883ec20             | mov                 dword ptr [ebp + 0x7f], eax
            //   488bd9               | mov                 eax, edi
            //   ba60000000           | mov                 edx, edi
            //   b958000000           | rol                 eax, 7
            //   488b4360             | ror                 edx, 0xb
            //   48394358             | inc                 ecx
            //   0f42d1               | lea                 ecx, [ebx + 3]

        $sequence_4 = { 498b4210 4c3bc1 4983d700 48f76328 4f8d343c 488bf2 498d0c00 }
            // n = 7, score = 200
            //   498b4210             | dec                 ecx
            //   4c3bc1               | mov                 eax, dword ptr [edx + 8]
            //   4983d700             | dec                 ecx
            //   48f76328             | cmp                 ecx, eax
            //   4f8d343c             | dec                 eax
            //   488bf2               | mul                 dword ptr [ebx + 0x38]
            //   498d0c00             | dec                 esp

        $sequence_5 = { 498d0c01 498b4528 493bc9 4983d400 49f76328 4f8d3427 488bf2 }
            // n = 7, score = 200
            //   498d0c01             | dec                 ebp
            //   498b4528             | adc                 esi, ebp
            //   493bc9               | dec                 ecx
            //   4983d400             | mul                 dword ptr [esp]
            //   49f76328             | dec                 eax
            //   4f8d3427             | mov                 ecx, eax
            //   488bf2               | dec                 esp

        $sequence_6 = { 4883fa10 7203 488b07 488d1c08 41b817000000 488d15605f0600 488bcb }
            // n = 7, score = 200
            //   4883fa10             | dec                 eax
            //   7203                 | lea                 ecx, [ebp - 0x41]
            //   488b07               | dec                 eax
            //   488d1c08             | mov                 edi, dword ptr [ebp + 0x67]
            //   41b817000000         | mov                 eax, 2
            //   488d15605f0600       | inc                 esp
            //   488bcb               | add                 edx, eax

        $sequence_7 = { 4883d200 4c03e2 4889559f 48f76648 498d0c00 498b4348 493bc8 }
            // n = 7, score = 200
            //   4883d200             | xor                 ecx, ebx
            //   4c03e2               | inc                 ecx
            //   4889559f             | mov                 eax, eax
            //   48f76648             | rol                 eax, 0xd
            //   498d0c00             | xor                 ecx, eax
            //   498b4348             | inc                 ecx
            //   493bc8               | mov                 eax, eax

        $sequence_8 = { 8b4510 0416 346d 88452a 8b4510 0417 3465 }
            // n = 7, score = 200
            //   8b4510               | dec                 ecx
            //   0416                 | mov                 eax, dword ptr [ecx]
            //   346d                 | dec                 esp
            //   88452a               | cmp                 eax, ecx
            //   8b4510               | dec                 eax
            //   0417                 | mov                 ecx, dword ptr [ebp + 0x67]
            //   3465                 | dec                 ecx

        $sequence_9 = { 4833c4 48898590010000 4c8bad08020000 0f57c0 0f1185b0000000 0f1185c0000000 0f1185d0000000 }
            // n = 7, score = 200
            //   4833c4               | xor                 eax, edx
            //   48898590010000       | and                 ecx, ebx
            //   4c8bad08020000       | mov                 ebx, dword ptr [esp]
            //   0f57c0               | xor                 edx, eax
            //   0f1185b0000000       | mov                 eax, ecx
            //   0f1185c0000000       | ror                 eax, 6
            //   0f1185d0000000       | xor                 edx, eax

    condition:
        7 of them and filesize < 1163264
}