rule win_lorenz_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.lorenz."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lorenz"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4dfc 8b55fc 8b8100050000 2b8204050000 83f801 7515 b904000000 }
            // n = 7, score = 300
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   8b8100050000         | mov                 eax, dword ptr [ecx + 0x500]
            //   2b8204050000         | sub                 eax, dword ptr [edx + 0x504]
            //   83f801               | cmp                 eax, 1
            //   7515                 | jne                 0x17
            //   b904000000           | mov                 ecx, 4

        $sequence_1 = { 8b4df0 83c110 e9???????? 8b4df0 83c160 e9???????? 8d4de0 }
            // n = 7, score = 300
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   83c110               | add                 ecx, 0x10
            //   e9????????           |                     
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   83c160               | add                 ecx, 0x60
            //   e9????????           |                     
            //   8d4de0               | lea                 ecx, [ebp - 0x20]

        $sequence_2 = { 8bc8 e8???????? 0fb6c0 85c0 743b 8d4dd4 e8???????? }
            // n = 7, score = 300
            //   8bc8                 | mov                 ecx, eax
            //   e8????????           |                     
            //   0fb6c0               | movzx               eax, al
            //   85c0                 | test                eax, eax
            //   743b                 | je                  0x3d
            //   8d4dd4               | lea                 ecx, [ebp - 0x2c]
            //   e8????????           |                     

        $sequence_3 = { 8b55fc 898a20080000 8b45fc c7802c08000000000000 8b4dfc c7813008000000000000 8b55fc }
            // n = 7, score = 300
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   898a20080000         | mov                 dword ptr [edx + 0x820], ecx
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   c7802c08000000000000     | mov    dword ptr [eax + 0x82c], 0
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   c7813008000000000000     | mov    dword ptr [ecx + 0x830], 0
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]

        $sequence_4 = { f00fb10a 3d00000080 0f8588000000 8b45f0 83c01c 50 6a04 }
            // n = 7, score = 300
            //   f00fb10a             | lock cmpxchg        dword ptr [edx], ecx
            //   3d00000080           | cmp                 eax, 0x80000000
            //   0f8588000000         | jne                 0x8e
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   83c01c               | add                 eax, 0x1c
            //   50                   | push                eax
            //   6a04                 | push                4

        $sequence_5 = { c7402000000000 8b4d0c e8???????? 8b4dfc 894124 8b4d0c e8???????? }
            // n = 7, score = 300
            //   c7402000000000       | mov                 dword ptr [eax + 0x20], 0
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   e8????????           |                     
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   894124               | mov                 dword ptr [ecx + 0x24], eax
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   e8????????           |                     

        $sequence_6 = { eb05 e8???????? e9???????? 837d14ff 0f84ac000000 8b45ec 83781400 }
            // n = 7, score = 300
            //   eb05                 | jmp                 7
            //   e8????????           |                     
            //   e9????????           |                     
            //   837d14ff             | cmp                 dword ptr [ebp + 0x14], -1
            //   0f84ac000000         | je                  0xb2
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   83781400             | cmp                 dword ptr [eax + 0x14], 0

        $sequence_7 = { cc 33c0 75d0 33c9 75cc 837df820 7f0e }
            // n = 7, score = 300
            //   cc                   | int3                
            //   33c0                 | xor                 eax, eax
            //   75d0                 | jne                 0xffffffd2
            //   33c9                 | xor                 ecx, ecx
            //   75cc                 | jne                 0xffffffce
            //   837df820             | cmp                 dword ptr [ebp - 8], 0x20
            //   7f0e                 | jg                  0x10

        $sequence_8 = { 8b4d08 51 e8???????? 83c410 8b55f0 83ca01 8955f0 }
            // n = 7, score = 300
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   8b55f0               | mov                 edx, dword ptr [ebp - 0x10]
            //   83ca01               | or                  edx, 1
            //   8955f0               | mov                 dword ptr [ebp - 0x10], edx

        $sequence_9 = { 8bec 83ec08 894df8 837d0800 7414 8b4508 833800 }
            // n = 7, score = 300
            //   8bec                 | mov                 ebp, esp
            //   83ec08               | sub                 esp, 8
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   837d0800             | cmp                 dword ptr [ebp + 8], 0
            //   7414                 | je                  0x16
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   833800               | cmp                 dword ptr [eax], 0

    condition:
        7 of them and filesize < 2254848
}