rule win_lowzero_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.lowzero."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lowzero"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 53 ffd0 85c0 750a 685a040000 e9???????? c7471001000000 }
            // n = 7, score = 200
            //   53                   | push                ebx
            //   ffd0                 | call                eax
            //   85c0                 | test                eax, eax
            //   750a                 | jne                 0xc
            //   685a040000           | push                0x45a
            //   e9????????           |                     
            //   c7471001000000       | mov                 dword ptr [edi + 0x10], 1

        $sequence_1 = { 7439 03c3 837f1400 7425 }
            // n = 4, score = 200
            //   7439                 | je                  0x3b
            //   03c3                 | add                 eax, ebx
            //   837f1400             | cmp                 dword ptr [edi + 0x14], 0
            //   7425                 | je                  0x27

        $sequence_2 = { 8b45d4 89473c 8b441154 3945f4 7318 6a0d ff15???????? }
            // n = 7, score = 200
            //   8b45d4               | mov                 eax, dword ptr [ebp - 0x2c]
            //   89473c               | mov                 dword ptr [edi + 0x3c], eax
            //   8b441154             | mov                 eax, dword ptr [ecx + edx + 0x54]
            //   3945f4               | cmp                 dword ptr [ebp - 0xc], eax
            //   7318                 | jae                 0x1a
            //   6a0d                 | push                0xd
            //   ff15????????         |                     

        $sequence_3 = { 47 2bc8 8d4602 03c3 3b450c }
            // n = 5, score = 200
            //   47                   | inc                 edi
            //   2bc8                 | sub                 ecx, eax
            //   8d4602               | lea                 eax, [esi + 2]
            //   03c3                 | add                 eax, ebx
            //   3b450c               | cmp                 eax, dword ptr [ebp + 0xc]

        $sequence_4 = { e8???????? 83c40c 03f3 eb0b 2bce 8a0431 }
            // n = 6, score = 200
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   03f3                 | add                 esi, ebx
            //   eb0b                 | jmp                 0xd
            //   2bce                 | sub                 ecx, esi
            //   8a0431               | mov                 al, byte ptr [ecx + esi]

        $sequence_5 = { 8945f0 8945d8 eb25 8b03 }
            // n = 4, score = 200
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   8945d8               | mov                 dword ptr [ebp - 0x28], eax
            //   eb25                 | jmp                 0x27
            //   8b03                 | mov                 eax, dword ptr [ebx]

        $sequence_6 = { 0fb61f 83c307 47 0fb607 47 2bc8 }
            // n = 6, score = 200
            //   0fb61f               | movzx               ebx, byte ptr [edi]
            //   83c307               | add                 ebx, 7
            //   47                   | inc                 edi
            //   0fb607               | movzx               eax, byte ptr [edi]
            //   47                   | inc                 edi
            //   2bc8                 | sub                 ecx, eax

        $sequence_7 = { 56 e8???????? 8b55fc 8bca 57 8b423c 8b55f4 }
            // n = 7, score = 200
            //   56                   | push                esi
            //   e8????????           |                     
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   8bca                 | mov                 ecx, edx
            //   57                   | push                edi
            //   8b423c               | mov                 eax, dword ptr [edx + 0x3c]
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]

        $sequence_8 = { 2bca 49 83fb07 7507 0fb61f 83c307 }
            // n = 6, score = 200
            //   2bca                 | sub                 ecx, edx
            //   49                   | dec                 ecx
            //   83fb07               | cmp                 ebx, 7
            //   7507                 | jne                 9
            //   0fb61f               | movzx               ebx, byte ptr [edi]
            //   83c307               | add                 ebx, 7

        $sequence_9 = { 6a01 53 ffd0 85c0 750a 685a040000 }
            // n = 6, score = 200
            //   6a01                 | push                1
            //   53                   | push                ebx
            //   ffd0                 | call                eax
            //   85c0                 | test                eax, eax
            //   750a                 | jne                 0xc
            //   685a040000           | push                0x45a

    condition:
        7 of them and filesize < 433152
}