rule win_lumar_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.lumar."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lumar"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b55f8 8b4df0 56 e8???????? 83c418 8bce e8???????? }
            // n = 7, score = 100
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   56                   | push                esi
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     

        $sequence_1 = { 8b450c 48 89450c 8b45f4 3b45b8 730f 8b45f8 }
            // n = 7, score = 100
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   48                   | dec                 eax
            //   89450c               | mov                 dword ptr [ebp + 0xc], eax
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   3b45b8               | cmp                 eax, dword ptr [ebp - 0x48]
            //   730f                 | jae                 0x11
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]

        $sequence_2 = { 8a06 3ac3 7de6 8a06 6a03 5b 3c6c }
            // n = 7, score = 100
            //   8a06                 | mov                 al, byte ptr [esi]
            //   3ac3                 | cmp                 al, bl
            //   7de6                 | jge                 0xffffffe8
            //   8a06                 | mov                 al, byte ptr [esi]
            //   6a03                 | push                3
            //   5b                   | pop                 ebx
            //   3c6c                 | cmp                 al, 0x6c

        $sequence_3 = { 83e801 740b 2bc3 742d 83620c00 4e }
            // n = 6, score = 100
            //   83e801               | sub                 eax, 1
            //   740b                 | je                  0xd
            //   2bc3                 | sub                 eax, ebx
            //   742d                 | je                  0x2f
            //   83620c00             | and                 dword ptr [edx + 0xc], 0
            //   4e                   | dec                 esi

        $sequence_4 = { 7618 8b848d74fbffff 89948d74fbffff 03d0 41 3bce }
            // n = 6, score = 100
            //   7618                 | jbe                 0x1a
            //   8b848d74fbffff       | mov                 eax, dword ptr [ebp + ecx*4 - 0x48c]
            //   89948d74fbffff       | mov                 dword ptr [ebp + ecx*4 - 0x48c], edx
            //   03d0                 | add                 edx, eax
            //   41                   | inc                 ecx
            //   3bce                 | cmp                 ecx, esi

        $sequence_5 = { 8d8534ffffff 59 0fb70d???????? 0f45d1 0fb7ca 41 }
            // n = 6, score = 100
            //   8d8534ffffff         | lea                 eax, [ebp - 0xcc]
            //   59                   | pop                 ecx
            //   0fb70d????????       |                     
            //   0f45d1               | cmovne              edx, ecx
            //   0fb7ca               | movzx               ecx, dx
            //   41                   | inc                 ecx

        $sequence_6 = { 8bec b804100000 e8???????? 53 56 57 bb00100000 }
            // n = 7, score = 100
            //   8bec                 | mov                 ebp, esp
            //   b804100000           | mov                 eax, 0x1004
            //   e8????????           |                     
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   bb00100000           | mov                 ebx, 0x1000

        $sequence_7 = { e8???????? 83c40c 8945f0 8365e400 8b45b0 83e001 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   8365e400             | and                 dword ptr [ebp - 0x1c], 0
            //   8b45b0               | mov                 eax, dword ptr [ebp - 0x50]
            //   83e001               | and                 eax, 1

        $sequence_8 = { 83fa02 73e1 5e c3 55 8bec }
            // n = 6, score = 100
            //   83fa02               | cmp                 edx, 2
            //   73e1                 | jae                 0xffffffe3
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp

        $sequence_9 = { c60430c3 8d45fc 895dfc 50 ff15???????? 50 ff15???????? }
            // n = 7, score = 100
            //   c60430c3             | mov                 byte ptr [eax + esi], 0xc3
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx
            //   50                   | push                eax
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ff15????????         |                     

    condition:
        7 of them and filesize < 81920
}