rule win_lurk_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.lurk."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lurk"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff7508 ff15???????? 8b35???????? 50 ff7508 }
            // n = 5, score = 1100
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ff15????????         |                     
            //   8b35????????         |                     
            //   50                   | push                eax
            //   ff7508               | push                dword ptr [ebp + 8]

        $sequence_1 = { 8b4508 5b 5f 5e c9 c3 55 }
            // n = 7, score = 900
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   5b                   | pop                 ebx
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   c9                   | leave               
            //   c3                   | ret                 
            //   55                   | push                ebp

        $sequence_2 = { 384807 7562 384808 755d 384809 }
            // n = 5, score = 800
            //   384807               | cmp                 byte ptr [eax + 7], cl
            //   7562                 | jne                 0x64
            //   384808               | cmp                 byte ptr [eax + 8], cl
            //   755d                 | jne                 0x5f
            //   384809               | cmp                 byte ptr [eax + 9], cl

        $sequence_3 = { c1ee05 33ce f7d1 33c1 42 43 3b5c2410 }
            // n = 7, score = 800
            //   c1ee05               | shr                 esi, 5
            //   33ce                 | xor                 ecx, esi
            //   f7d1                 | not                 ecx
            //   33c1                 | xor                 eax, ecx
            //   42                   | inc                 edx
            //   43                   | inc                 ebx
            //   3b5c2410             | cmp                 ebx, dword ptr [esp + 0x10]

        $sequence_4 = { c1f803 8945f4 c745f800000000 eb09 8b4df8 83c101 894df8 }
            // n = 7, score = 800
            //   c1f803               | sar                 eax, 3
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   c745f800000000       | mov                 dword ptr [ebp - 8], 0
            //   eb09                 | jmp                 0xb
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   83c101               | add                 ecx, 1
            //   894df8               | mov                 dword ptr [ebp - 8], ecx

        $sequence_5 = { 8b7c240c 33f6 6a04 57 6a03 e8???????? 83c40c }
            // n = 7, score = 800
            //   8b7c240c             | mov                 edi, dword ptr [esp + 0xc]
            //   33f6                 | xor                 esi, esi
            //   6a04                 | push                4
            //   57                   | push                edi
            //   6a03                 | push                3
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_6 = { ffd6 83f802 7546 8365bc00 8d45b8 50 6a20 }
            // n = 7, score = 800
            //   ffd6                 | call                esi
            //   83f802               | cmp                 eax, 2
            //   7546                 | jne                 0x48
            //   8365bc00             | and                 dword ptr [ebp - 0x44], 0
            //   8d45b8               | lea                 eax, [ebp - 0x48]
            //   50                   | push                eax
            //   6a20                 | push                0x20

        $sequence_7 = { 8b4d08 ff75f8 03c3 c7406045763812 }
            // n = 4, score = 800
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   03c3                 | add                 eax, ebx
            //   c7406045763812       | mov                 dword ptr [eax + 0x60], 0x12387645

        $sequence_8 = { 8b4d08 8d440802 50 ff75fc ff5714 }
            // n = 5, score = 800
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8d440802             | lea                 eax, [eax + ecx + 2]
            //   50                   | push                eax
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ff5714               | call                dword ptr [edi + 0x14]

        $sequence_9 = { 8b4dd8 0308 894db8 8365bc00 8b45bc c1c80d 8945bc }
            // n = 7, score = 800
            //   8b4dd8               | mov                 ecx, dword ptr [ebp - 0x28]
            //   0308                 | add                 ecx, dword ptr [eax]
            //   894db8               | mov                 dword ptr [ebp - 0x48], ecx
            //   8365bc00             | and                 dword ptr [ebp - 0x44], 0
            //   8b45bc               | mov                 eax, dword ptr [ebp - 0x44]
            //   c1c80d               | ror                 eax, 0xd
            //   8945bc               | mov                 dword ptr [ebp - 0x44], eax

        $sequence_10 = { 74de 56 8b35???????? 8d85fcfeffff 50 ffd6 8d8dfcfeffff }
            // n = 7, score = 800
            //   74de                 | je                  0xffffffe0
            //   56                   | push                esi
            //   8b35????????         |                     
            //   8d85fcfeffff         | lea                 eax, [ebp - 0x104]
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   8d8dfcfeffff         | lea                 ecx, [ebp - 0x104]

        $sequence_11 = { 8945cc 8b45e0 668b4024 668945c8 }
            // n = 4, score = 800
            //   8945cc               | mov                 dword ptr [ebp - 0x34], eax
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]
            //   668b4024             | mov                 ax, word ptr [eax + 0x24]
            //   668945c8             | mov                 word ptr [ebp - 0x38], ax

        $sequence_12 = { c645fa25 c645fb75 c645fc2f c645fd00 e8???????? }
            // n = 5, score = 800
            //   c645fa25             | mov                 byte ptr [ebp - 6], 0x25
            //   c645fb75             | mov                 byte ptr [ebp - 5], 0x75
            //   c645fc2f             | mov                 byte ptr [ebp - 4], 0x2f
            //   c645fd00             | mov                 byte ptr [ebp - 3], 0
            //   e8????????           |                     

        $sequence_13 = { ff7508 ff7510 e8???????? 83c418 85c0 7502 33f6 }
            // n = 7, score = 800
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   85c0                 | test                eax, eax
            //   7502                 | jne                 4
            //   33f6                 | xor                 esi, esi

        $sequence_14 = { 8b4d08 8d540102 8955f8 8b45f8 }
            // n = 4, score = 800
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8d540102             | lea                 edx, [ecx + eax + 2]
            //   8955f8               | mov                 dword ptr [ebp - 8], edx
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]

        $sequence_15 = { 8bec 83ec0c 53 56 8b7508 0fb606 }
            // n = 6, score = 800
            //   8bec                 | mov                 ebp, esp
            //   83ec0c               | sub                 esp, 0xc
            //   53                   | push                ebx
            //   56                   | push                esi
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   0fb606               | movzx               eax, byte ptr [esi]

    condition:
        7 of them and filesize < 5316608
}