rule win_madmax_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.madmax."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.madmax"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { f6897b3c7a8156 c10a9c 7ed2 1550605965 91 186b72 b293 }
            // n = 7, score = 100
            //   f6897b3c7a8156       | test                byte ptr [ecx - 0x7e85c385], 0x56
            //   c10a9c               | ror                 dword ptr [edx], 0x9c
            //   7ed2                 | jle                 0xffffffd4
            //   1550605965           | adc                 eax, 0x65596050
            //   91                   | xchg                eax, ecx
            //   186b72               | sbb                 byte ptr [ebx + 0x72], ch
            //   b293                 | mov                 dl, 0x93

        $sequence_1 = { b852e635a0 b5cb 85c6 1cfe 48 853f 237ab7 }
            // n = 7, score = 100
            //   b852e635a0           | mov                 eax, 0xa035e652
            //   b5cb                 | mov                 ch, 0xcb
            //   85c6                 | test                esi, eax
            //   1cfe                 | sbb                 al, 0xfe
            //   48                   | dec                 eax
            //   853f                 | test                dword ptr [edi], edi
            //   237ab7               | and                 edi, dword ptr [edx - 0x49]

        $sequence_2 = { f64f0a9b 10678e 58 b0df af 72f1 e5c9 }
            // n = 7, score = 100
            //   f64f0a9b             | test                byte ptr [edi + 0xa], 0x9b
            //   10678e               | adc                 byte ptr [edi - 0x72], ah
            //   58                   | pop                 eax
            //   b0df                 | mov                 al, 0xdf
            //   af                   | scasd               eax, dword ptr es:[edi]
            //   72f1                 | jb                  0xfffffff3
            //   e5c9                 | in                  eax, 0xc9

        $sequence_3 = { d6 b401 db59f6 55 94 58 4c }
            // n = 7, score = 100
            //   d6                   | salc                
            //   b401                 | mov                 ah, 1
            //   db59f6               | fistp               dword ptr [ecx - 0xa]
            //   55                   | push                ebp
            //   94                   | xchg                eax, esp
            //   58                   | pop                 eax
            //   4c                   | dec                 esp

        $sequence_4 = { f8 df29 18ce 84617b 0ca6 08ba685649a2 7b28 }
            // n = 7, score = 100
            //   f8                   | clc                 
            //   df29                 | fild                qword ptr [ecx]
            //   18ce                 | sbb                 dh, cl
            //   84617b               | test                byte ptr [ecx + 0x7b], ah
            //   0ca6                 | or                  al, 0xa6
            //   08ba685649a2         | or                  byte ptr [edx - 0x5db6a998], bh
            //   7b28                 | jnp                 0x2a

        $sequence_5 = { a7 16 d293b6f8cf83 91 63636f 834bb565 98 }
            // n = 7, score = 100
            //   a7                   | cmpsd               dword ptr [esi], dword ptr es:[edi]
            //   16                   | push                ss
            //   d293b6f8cf83         | rcl                 byte ptr [ebx - 0x7c30074a], cl
            //   91                   | xchg                eax, ecx
            //   63636f               | arpl                word ptr [ebx + 0x6f], sp
            //   834bb565             | or                  dword ptr [ebx - 0x4b], 0x65
            //   98                   | cwde                

        $sequence_6 = { fc 5b 359e973298 1816 2a3ce4 7d62 f616 }
            // n = 7, score = 100
            //   fc                   | cld                 
            //   5b                   | pop                 ebx
            //   359e973298           | xor                 eax, 0x9832979e
            //   1816                 | sbb                 byte ptr [esi], dl
            //   2a3ce4               | sub                 bh, byte ptr [esp]
            //   7d62                 | jge                 0x64
            //   f616                 | not                 byte ptr [esi]

        $sequence_7 = { e02e fa 4b 2f d9e0 cd6c 3adf }
            // n = 7, score = 100
            //   e02e                 | loopne              0x30
            //   fa                   | cli                 
            //   4b                   | dec                 ebx
            //   2f                   | das                 
            //   d9e0                 | fchs                
            //   cd6c                 | int                 0x6c
            //   3adf                 | cmp                 bl, bh

        $sequence_8 = { 8d8508feffff 9c f605????????d3 0f85d3000000 3efd 27 40 }
            // n = 7, score = 100
            //   8d8508feffff         | lea                 eax, [ebp - 0x1f8]
            //   9c                   | pushfd              
            //   f605????????d3       |                     
            //   0f85d3000000         | jne                 0xd9
            //   3efd                 | std                 
            //   27                   | daa                 
            //   40                   | inc                 eax

        $sequence_9 = { e652 45 23a7cb3626db a9886e48e3 3407 d120 c1f37d }
            // n = 7, score = 100
            //   e652                 | out                 0x52, al
            //   45                   | inc                 ebp
            //   23a7cb3626db         | and                 esp, dword ptr [edi - 0x24d9c935]
            //   a9886e48e3           | test                eax, 0xe3486e88
            //   3407                 | xor                 al, 7
            //   d120                 | shl                 dword ptr [eax], 1
            //   c1f37d               | sal                 ebx, 0x7d

    condition:
        7 of them and filesize < 3227648
}