rule win_maktub_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.maktub."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.maktub"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ffd0 f7d8 1bc0 f7d8 8be5 }
            // n = 5, score = 400
            //   ffd0                 | call                eax
            //   f7d8                 | neg                 eax
            //   1bc0                 | sbb                 eax, eax
            //   f7d8                 | neg                 eax
            //   8be5                 | mov                 esp, ebp

        $sequence_1 = { ff7508 ffd0 85c0 0f846bffffff }
            // n = 4, score = 300
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ffd0                 | call                eax
            //   85c0                 | test                eax, eax
            //   0f846bffffff         | je                  0xffffff71

        $sequence_2 = { ff15???????? c74604???????? c70601000000 eb02 33f6 8b0d???????? }
            // n = 6, score = 300
            //   ff15????????         |                     
            //   c74604????????       |                     
            //   c70601000000         | mov                 dword ptr [esi], 1
            //   eb02                 | jmp                 4
            //   33f6                 | xor                 esi, esi
            //   8b0d????????         |                     

        $sequence_3 = { c7430800000000 c7430c00000000 85f6 7428 a1???????? 8b3e 85c0 }
            // n = 7, score = 300
            //   c7430800000000       | mov                 dword ptr [ebx + 8], 0
            //   c7430c00000000       | mov                 dword ptr [ebx + 0xc], 0
            //   85f6                 | test                esi, esi
            //   7428                 | je                  0x2a
            //   a1????????           |                     
            //   8b3e                 | mov                 edi, dword ptr [esi]
            //   85c0                 | test                eax, eax

        $sequence_4 = { ff15???????? c74604???????? c70602000000 eb02 }
            // n = 4, score = 300
            //   ff15????????         |                     
            //   c74604????????       |                     
            //   c70602000000         | mov                 dword ptr [esi], 2
            //   eb02                 | jmp                 4

        $sequence_5 = { ff15???????? e9???????? 6a00 8d45f8 c745f800000000 }
            // n = 5, score = 300
            //   ff15????????         |                     
            //   e9????????           |                     
            //   6a00                 | push                0
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   c745f800000000       | mov                 dword ptr [ebp - 8], 0

        $sequence_6 = { ff15???????? e9???????? 51 8bdc }
            // n = 4, score = 300
            //   ff15????????         |                     
            //   e9????????           |                     
            //   51                   | push                ecx
            //   8bdc                 | mov                 ebx, esp

        $sequence_7 = { c7430800000000 c7430c00000000 c7430400000000 c70300000000 }
            // n = 4, score = 300
            //   c7430800000000       | mov                 dword ptr [ebx + 8], 0
            //   c7430c00000000       | mov                 dword ptr [ebx + 0xc], 0
            //   c7430400000000       | mov                 dword ptr [ebx + 4], 0
            //   c70300000000         | mov                 dword ptr [ebx], 0

        $sequence_8 = { ff30 e8???????? 8bc7 5f 5e 5b }
            // n = 6, score = 200
            //   ff30                 | push                dword ptr [eax]
            //   e8????????           |                     
            //   8bc7                 | mov                 eax, edi
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx

        $sequence_9 = { 8d4e48 e8???????? 6a05 8bce e8???????? 5f }
            // n = 6, score = 100
            //   8d4e48               | lea                 ecx, [esi + 0x48]
            //   e8????????           |                     
            //   6a05                 | push                5
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   5f                   | pop                 edi

        $sequence_10 = { c7461407000000 33c0 668906 5e c20800 b8???????? e8???????? }
            // n = 7, score = 100
            //   c7461407000000       | mov                 dword ptr [esi + 0x14], 7
            //   33c0                 | xor                 eax, eax
            //   668906               | mov                 word ptr [esi], ax
            //   5e                   | pop                 esi
            //   c20800               | ret                 8
            //   b8????????           |                     
            //   e8????????           |                     

        $sequence_11 = { 8d4e48 e8???????? 8d4e34 e8???????? 8d4e08 }
            // n = 5, score = 100
            //   8d4e48               | lea                 ecx, [esi + 0x48]
            //   e8????????           |                     
            //   8d4e34               | lea                 ecx, [esi + 0x34]
            //   e8????????           |                     
            //   8d4e08               | lea                 ecx, [esi + 8]

        $sequence_12 = { 8d4e50 e8???????? 8bc6 5e }
            // n = 4, score = 100
            //   8d4e50               | lea                 ecx, [esi + 0x50]
            //   e8????????           |                     
            //   8bc6                 | mov                 eax, esi
            //   5e                   | pop                 esi

        $sequence_13 = { 8d4e50 e8???????? 8d4e40 e8???????? 8d4e30 e8???????? 8d4e1c }
            // n = 7, score = 100
            //   8d4e50               | lea                 ecx, [esi + 0x50]
            //   e8????????           |                     
            //   8d4e40               | lea                 ecx, [esi + 0x40]
            //   e8????????           |                     
            //   8d4e30               | lea                 ecx, [esi + 0x30]
            //   e8????????           |                     
            //   8d4e1c               | lea                 ecx, [esi + 0x1c]

        $sequence_14 = { c7463464204d00 c7463806000000 c6463c00 5f }
            // n = 4, score = 100
            //   c7463464204d00       | mov                 dword ptr [esi + 0x34], 0x4d2064
            //   c7463806000000       | mov                 dword ptr [esi + 0x38], 6
            //   c6463c00             | mov                 byte ptr [esi + 0x3c], 0
            //   5f                   | pop                 edi

        $sequence_15 = { c7463464204d00 57 ff7634 e8???????? }
            // n = 4, score = 100
            //   c7463464204d00       | mov                 dword ptr [esi + 0x34], 0x4d2064
            //   57                   | push                edi
            //   ff7634               | push                dword ptr [esi + 0x34]
            //   e8????????           |                     

        $sequence_16 = { 8d4e68 e8???????? 83a6b400000000 8d8eb8000000 }
            // n = 4, score = 100
            //   8d4e68               | lea                 ecx, [esi + 0x68]
            //   e8????????           |                     
            //   83a6b400000000       | and                 dword ptr [esi + 0xb4], 0
            //   8d8eb8000000         | lea                 ecx, [esi + 0xb8]

        $sequence_17 = { c7461c00000000 85db 741a 68b4000000 }
            // n = 4, score = 100
            //   c7461c00000000       | mov                 dword ptr [esi + 0x1c], 0
            //   85db                 | test                ebx, ebx
            //   741a                 | je                  0x1c
            //   68b4000000           | push                0xb4

        $sequence_18 = { 8d4e48 e8???????? 814e0400000080 8bc6 }
            // n = 4, score = 100
            //   8d4e48               | lea                 ecx, [esi + 0x48]
            //   e8????????           |                     
            //   814e0400000080       | or                  dword ptr [esi + 4], 0x80000000
            //   8bc6                 | mov                 eax, esi

        $sequence_19 = { c7463464204d00 6a00 57 8bce }
            // n = 4, score = 100
            //   c7463464204d00       | mov                 dword ptr [esi + 0x34], 0x4d2064
            //   6a00                 | push                0
            //   57                   | push                edi
            //   8bce                 | mov                 ecx, esi

        $sequence_20 = { c746140f000000 c60600 5e c20800 8b542404 }
            // n = 5, score = 100
            //   c746140f000000       | mov                 dword ptr [esi + 0x14], 0xf
            //   c60600               | mov                 byte ptr [esi], 0
            //   5e                   | pop                 esi
            //   c20800               | ret                 8
            //   8b542404             | mov                 edx, dword ptr [esp + 4]

        $sequence_21 = { 8d4e50 e8???????? 8d4df0 e8???????? }
            // n = 4, score = 100
            //   8d4e50               | lea                 ecx, [esi + 0x50]
            //   e8????????           |                     
            //   8d4df0               | lea                 ecx, [ebp - 0x10]
            //   e8????????           |                     

    condition:
        7 of them and filesize < 3063808
}