rule win_matsnu_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.matsnu."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.matsnu"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 751d ff75ba ff7510 e8???????? 8945f6 }
            // n = 5, score = 700
            //   751d                 | jne                 0x1f
            //   ff75ba               | push                dword ptr [ebp - 0x46]
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   e8????????           |                     
            //   8945f6               | mov                 dword ptr [ebp - 0xa], eax

        $sequence_1 = { 2945ce ebd3 c745d600000000 c745da00010000 c745e200000000 }
            // n = 5, score = 700
            //   2945ce               | sub                 dword ptr [ebp - 0x32], eax
            //   ebd3                 | jmp                 0xffffffd5
            //   c745d600000000       | mov                 dword ptr [ebp - 0x2a], 0
            //   c745da00010000       | mov                 dword ptr [ebp - 0x26], 0x100
            //   c745e200000000       | mov                 dword ptr [ebp - 0x1e], 0

        $sequence_2 = { 8b45e6 8807 eb75 817dd6000f0000 }
            // n = 4, score = 700
            //   8b45e6               | mov                 eax, dword ptr [ebp - 0x1a]
            //   8807                 | mov                 byte ptr [edi], al
            //   eb75                 | jmp                 0x77
            //   817dd6000f0000       | cmp                 dword ptr [ebp - 0x2a], 0xf00

        $sequence_3 = { c1e004 8b7dfa 01c7 8b45de 8907 8b45e6 c1e004 }
            // n = 7, score = 700
            //   c1e004               | shl                 eax, 4
            //   8b7dfa               | mov                 edi, dword ptr [ebp - 6]
            //   01c7                 | add                 edi, eax
            //   8b45de               | mov                 eax, dword ptr [ebp - 0x22]
            //   8907                 | mov                 dword ptr [edi], eax
            //   8b45e6               | mov                 eax, dword ptr [ebp - 0x1a]
            //   c1e004               | shl                 eax, 4

        $sequence_4 = { 8b75fa 01c6 8b36 0375ea 8b7d10 }
            // n = 5, score = 700
            //   8b75fa               | mov                 esi, dword ptr [ebp - 6]
            //   01c6                 | add                 esi, eax
            //   8b36                 | mov                 esi, dword ptr [esi]
            //   0375ea               | add                 esi, dword ptr [ebp - 0x16]
            //   8b7d10               | mov                 edi, dword ptr [ebp + 0x10]

        $sequence_5 = { 7402 eb14 8d75f9 56 }
            // n = 4, score = 700
            //   7402                 | je                  4
            //   eb14                 | jmp                 0x16
            //   8d75f9               | lea                 esi, [ebp - 7]
            //   56                   | push                esi

        $sequence_6 = { 8b450c 8985c0fbffff 50 ff7508 }
            // n = 4, score = 700
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8985c0fbffff         | mov                 dword ptr [ebp - 0x440], eax
            //   50                   | push                eax
            //   ff7508               | push                dword ptr [ebp + 8]

        $sequence_7 = { 8a4e01 80e1f0 c0e904 08c8 8d55bc 01c2 8a02 }
            // n = 7, score = 700
            //   8a4e01               | mov                 cl, byte ptr [esi + 1]
            //   80e1f0               | and                 cl, 0xf0
            //   c0e904               | shr                 cl, 4
            //   08c8                 | or                  al, cl
            //   8d55bc               | lea                 edx, [ebp - 0x44]
            //   01c2                 | add                 edx, eax
            //   8a02                 | mov                 al, byte ptr [edx]

        $sequence_8 = { e8???????? 83f800 750f c785a4fbffff03000000 e9???????? }
            // n = 5, score = 700
            //   e8????????           |                     
            //   83f800               | cmp                 eax, 0
            //   750f                 | jne                 0x11
            //   c785a4fbffff03000000     | mov    dword ptr [ebp - 0x45c], 3
            //   e9????????           |                     

        $sequence_9 = { 55 89e5 81ec10020000 c785f0fdffff00000000 }
            // n = 4, score = 700
            //   55                   | push                ebp
            //   89e5                 | mov                 ebp, esp
            //   81ec10020000         | sub                 esp, 0x210
            //   c785f0fdffff00000000     | mov    dword ptr [ebp - 0x210], 0

    condition:
        7 of them and filesize < 606992
}