rule win_maudi_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.maudi."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.maudi"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 5d 8b542408 4a 0f85d9000000 68???????? 87d1 }
            // n = 6, score = 400
            //   5d                   | pop                 ebp
            //   8b542408             | mov                 edx, dword ptr [esp + 8]
            //   4a                   | dec                 edx
            //   0f85d9000000         | jne                 0xdf
            //   68????????           |                     
            //   87d1                 | xchg                ecx, edx

        $sequence_1 = { 87d1 87ca 51 51 51 }
            // n = 5, score = 400
            //   87d1                 | xchg                ecx, edx
            //   87ca                 | xchg                edx, ecx
            //   51                   | push                ecx
            //   51                   | push                ecx
            //   51                   | push                ecx

        $sequence_2 = { 56 55 89e5 5d 89e6 fc ad }
            // n = 7, score = 400
            //   56                   | push                esi
            //   55                   | push                ebp
            //   89e5                 | mov                 ebp, esp
            //   5d                   | pop                 ebp
            //   89e6                 | mov                 esi, esp
            //   fc                   | cld                 
            //   ad                   | lodsd               eax, dword ptr [esi]

        $sequence_3 = { 89e5 5d 89e6 fc ad 6804010000 56 }
            // n = 7, score = 400
            //   89e5                 | mov                 ebp, esp
            //   5d                   | pop                 ebp
            //   89e6                 | mov                 esi, esp
            //   fc                   | cld                 
            //   ad                   | lodsd               eax, dword ptr [esi]
            //   6804010000           | push                0x104
            //   56                   | push                esi

        $sequence_4 = { 59 ffe7 6800400000 6a00 57 68???????? }
            // n = 6, score = 400
            //   59                   | pop                 ecx
            //   ffe7                 | jmp                 edi
            //   6800400000           | push                0x4000
            //   6a00                 | push                0
            //   57                   | push                edi
            //   68????????           |                     

        $sequence_5 = { cd03 cd02 68???????? 87d1 87ca 51 }
            // n = 6, score = 400
            //   cd03                 | int                 3
            //   cd02                 | int                 2
            //   68????????           |                     
            //   87d1                 | xchg                ecx, edx
            //   87ca                 | xchg                edx, ecx
            //   51                   | push                ecx

        $sequence_6 = { 59 59 ffe7 6800400000 6a00 }
            // n = 5, score = 400
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   ffe7                 | jmp                 edi
            //   6800400000           | push                0x4000
            //   6a00                 | push                0

        $sequence_7 = { 6804010000 56 50 68???????? 87d1 }
            // n = 5, score = 400
            //   6804010000           | push                0x104
            //   56                   | push                esi
            //   50                   | push                eax
            //   68????????           |                     
            //   87d1                 | xchg                ecx, edx

        $sequence_8 = { 59 59 ff25???????? 55 }
            // n = 4, score = 400
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   ff25????????         |                     
            //   55                   | push                ebp

        $sequence_9 = { 5d b986180000 55 89e5 5d be???????? }
            // n = 6, score = 400
            //   5d                   | pop                 ebp
            //   b986180000           | mov                 ecx, 0x1886
            //   55                   | push                ebp
            //   89e5                 | mov                 ebp, esp
            //   5d                   | pop                 ebp
            //   be????????           |                     

    condition:
        7 of them and filesize < 40960
}