rule win_metadatabin_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.metadatabin."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.metadatabin"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b45f0 894708 f20f1045e8 f20f1107 e8???????? 6a0c 6a00 }
            // n = 7, score = 100
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   894708               | mov                 dword ptr [edi + 8], eax
            //   f20f1045e8           | movsd               xmm0, qword ptr [ebp - 0x18]
            //   f20f1107             | movsd               qword ptr [edi], xmm0
            //   e8????????           |                     
            //   6a0c                 | push                0xc
            //   6a00                 | push                0

        $sequence_1 = { 8d4aff 84c0 79dd 39f9 c745ec00000000 74bd 0fb65afe }
            // n = 7, score = 100
            //   8d4aff               | lea                 ecx, [edx - 1]
            //   84c0                 | test                al, al
            //   79dd                 | jns                 0xffffffdf
            //   39f9                 | cmp                 ecx, edi
            //   c745ec00000000       | mov                 dword ptr [ebp - 0x14], 0
            //   74bd                 | je                  0xffffffbf
            //   0fb65afe             | movzx               ebx, byte ptr [edx - 2]

        $sequence_2 = { 8b542468 0fa4fe0d 21842400030000 0fa4cb0d 8b842498000000 8bbc2440020000 89b424e0020000 }
            // n = 7, score = 100
            //   8b542468             | mov                 edx, dword ptr [esp + 0x68]
            //   0fa4fe0d             | shld                esi, edi, 0xd
            //   21842400030000       | and                 dword ptr [esp + 0x300], eax
            //   0fa4cb0d             | shld                ebx, ecx, 0xd
            //   8b842498000000       | mov                 eax, dword ptr [esp + 0x98]
            //   8bbc2440020000       | mov                 edi, dword ptr [esp + 0x240]
            //   89b424e0020000       | mov                 dword ptr [esp + 0x2e0], esi

        $sequence_3 = { 8b7df0 8b5de4 83fa08 725e 8d72f8 39f1 8975e0 }
            // n = 7, score = 100
            //   8b7df0               | mov                 edi, dword ptr [ebp - 0x10]
            //   8b5de4               | mov                 ebx, dword ptr [ebp - 0x1c]
            //   83fa08               | cmp                 edx, 8
            //   725e                 | jb                  0x60
            //   8d72f8               | lea                 esi, [edx - 8]
            //   39f1                 | cmp                 ecx, esi
            //   8975e0               | mov                 dword ptr [ebp - 0x20], esi

        $sequence_4 = { e8???????? b901000000 31d2 e9???????? 8b442418 89742430 895c2434 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   b901000000           | mov                 ecx, 1
            //   31d2                 | xor                 edx, edx
            //   e9????????           |                     
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]
            //   89742430             | mov                 dword ptr [esp + 0x30], esi
            //   895c2434             | mov                 dword ptr [esp + 0x34], ebx

        $sequence_5 = { c784246605000000000000 c784246a05000000000000 c784246e05000000000000 c784247205000000000000 c784247605000000000000 c784247a05000000000000 c684247e05000000 }
            // n = 7, score = 100
            //   c784246605000000000000     | mov    dword ptr [esp + 0x566], 0
            //   c784246a05000000000000     | mov    dword ptr [esp + 0x56a], 0
            //   c784246e05000000000000     | mov    dword ptr [esp + 0x56e], 0
            //   c784247205000000000000     | mov    dword ptr [esp + 0x572], 0
            //   c784247605000000000000     | mov    dword ptr [esp + 0x576], 0
            //   c784247a05000000000000     | mov    dword ptr [esp + 0x57a], 0
            //   c684247e05000000     | mov                 byte ptr [esp + 0x57e], 0

        $sequence_6 = { f20f115014 f20f11481c 837e4c00 0f85f4010000 e9???????? 8b4c2450 8b542460 }
            // n = 7, score = 100
            //   f20f115014           | movsd               qword ptr [eax + 0x14], xmm2
            //   f20f11481c           | movsd               qword ptr [eax + 0x1c], xmm1
            //   837e4c00             | cmp                 dword ptr [esi + 0x4c], 0
            //   0f85f4010000         | jne                 0x1fa
            //   e9????????           |                     
            //   8b4c2450             | mov                 ecx, dword ptr [esp + 0x50]
            //   8b542460             | mov                 edx, dword ptr [esp + 0x60]

        $sequence_7 = { 8d4e2c e8???????? eb08 8d4e20 e8???????? 8b465c 85c0 }
            // n = 7, score = 100
            //   8d4e2c               | lea                 ecx, [esi + 0x2c]
            //   e8????????           |                     
            //   eb08                 | jmp                 0xa
            //   8d4e20               | lea                 ecx, [esi + 0x20]
            //   e8????????           |                     
            //   8b465c               | mov                 eax, dword ptr [esi + 0x5c]
            //   85c0                 | test                eax, eax

        $sequence_8 = { 8b542438 c104240c 89442464 8b442408 c144246410 339424e4000000 338424a0000000 }
            // n = 7, score = 100
            //   8b542438             | mov                 edx, dword ptr [esp + 0x38]
            //   c104240c             | rol                 dword ptr [esp], 0xc
            //   89442464             | mov                 dword ptr [esp + 0x64], eax
            //   8b442408             | mov                 eax, dword ptr [esp + 8]
            //   c144246410           | rol                 dword ptr [esp + 0x64], 0x10
            //   339424e4000000       | xor                 edx, dword ptr [esp + 0xe4]
            //   338424a0000000       | xor                 eax, dword ptr [esp + 0xa0]

        $sequence_9 = { f00fc106 83e0c0 83f840 750e 8b4614 56 89d7 }
            // n = 7, score = 100
            //   f00fc106             | lock xadd           dword ptr [esi], eax
            //   83e0c0               | and                 eax, 0xffffffc0
            //   83f840               | cmp                 eax, 0x40
            //   750e                 | jne                 0x10
            //   8b4614               | mov                 eax, dword ptr [esi + 0x14]
            //   56                   | push                esi
            //   89d7                 | mov                 edi, edx

    condition:
        7 of them and filesize < 1263616
}