rule win_metastealer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.metastealer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.metastealer"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff75a0 ff7704 ff37 e8???????? 8b4704 83c410 c78564ffffffffffff7f }
            // n = 7, score = 300
            //   ff75a0               | push                dword ptr [ebp - 0x60]
            //   ff7704               | push                dword ptr [edi + 4]
            //   ff37                 | push                dword ptr [edi]
            //   e8????????           |                     
            //   8b4704               | mov                 eax, dword ptr [edi + 4]
            //   83c410               | add                 esp, 0x10
            //   c78564ffffffffffff7f     | mov    dword ptr [ebp - 0x9c], 0x7fffffff

        $sequence_1 = { f20f10c2 42 f20f5ec2 f20f5ac0 f30f11448e08 8b75c4 035d10 }
            // n = 7, score = 300
            //   f20f10c2             | movsd               xmm0, xmm2
            //   42                   | inc                 edx
            //   f20f5ec2             | divsd               xmm0, xmm2
            //   f20f5ac0             | cvtsd2ss            xmm0, xmm0
            //   f30f11448e08         | movss               dword ptr [esi + ecx*4 + 8], xmm0
            //   8b75c4               | mov                 esi, dword ptr [ebp - 0x3c]
            //   035d10               | add                 ebx, dword ptr [ebp + 0x10]

        $sequence_2 = { e8???????? 84c0 752d 8b4508 8b4018 894508 85c0 }
            // n = 7, score = 300
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   752d                 | jne                 0x2f
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b4018               | mov                 eax, dword ptr [eax + 0x18]
            //   894508               | mov                 dword ptr [ebp + 8], eax
            //   85c0                 | test                eax, eax

        $sequence_3 = { f30f5acb f30f5ac4 f20f590cce f20f58c8 f20f2dd1 81faff000000 760e }
            // n = 7, score = 300
            //   f30f5acb             | cvtss2sd            xmm1, xmm3
            //   f30f5ac4             | cvtss2sd            xmm0, xmm4
            //   f20f590cce           | mulsd               xmm1, qword ptr [esi + ecx*8]
            //   f20f58c8             | addsd               xmm1, xmm0
            //   f20f2dd1             | cvtsd2si            edx, xmm1
            //   81faff000000         | cmp                 edx, 0xff
            //   760e                 | jbe                 0x10

        $sequence_4 = { ff760c 68???????? 50 e8???????? 83c418 8bf8 c645fc07 }
            // n = 7, score = 300
            //   ff760c               | push                dword ptr [esi + 0xc]
            //   68????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   8bf8                 | mov                 edi, eax
            //   c645fc07             | mov                 byte ptr [ebp - 4], 7

        $sequence_5 = { e8???????? 83c404 8945f4 85c0 0f84c0150000 8bc8 33d2 }
            // n = 7, score = 300
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   85c0                 | test                eax, eax
            //   0f84c0150000         | je                  0x15c6
            //   8bc8                 | mov                 ecx, eax
            //   33d2                 | xor                 edx, edx

        $sequence_6 = { ffd0 0fb78e48020000 83c41c 3bc1 7416 68???????? 53 }
            // n = 7, score = 300
            //   ffd0                 | call                eax
            //   0fb78e48020000       | movzx               ecx, word ptr [esi + 0x248]
            //   83c41c               | add                 esp, 0x1c
            //   3bc1                 | cmp                 eax, ecx
            //   7416                 | je                  0x18
            //   68????????           |                     
            //   53                   | push                ebx

        $sequence_7 = { c78510f7ffff00000000 c78514f7ffff0000f03f e8???????? 68???????? 8d45a0 c7459800000000 50 }
            // n = 7, score = 300
            //   c78510f7ffff00000000     | mov    dword ptr [ebp - 0x8f0], 0
            //   c78514f7ffff0000f03f     | mov    dword ptr [ebp - 0x8ec], 0x3ff00000
            //   e8????????           |                     
            //   68????????           |                     
            //   8d45a0               | lea                 eax, [ebp - 0x60]
            //   c7459800000000       | mov                 dword ptr [ebp - 0x68], 0
            //   50                   | push                eax

        $sequence_8 = { c74610b4000000 b92d000000 c74614bf000000 be???????? f3a5 68???????? c680b400000000 }
            // n = 7, score = 300
            //   c74610b4000000       | mov                 dword ptr [esi + 0x10], 0xb4
            //   b92d000000           | mov                 ecx, 0x2d
            //   c74614bf000000       | mov                 dword ptr [esi + 0x14], 0xbf
            //   be????????           |                     
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   68????????           |                     
            //   c680b400000000       | mov                 byte ptr [eax + 0xb4], 0

        $sequence_9 = { f7472800008000 744e 8d8f88000000 85db 7506 46 8975fc }
            // n = 7, score = 300
            //   f7472800008000       | test                dword ptr [edi + 0x28], 0x800000
            //   744e                 | je                  0x50
            //   8d8f88000000         | lea                 ecx, [edi + 0x88]
            //   85db                 | test                ebx, ebx
            //   7506                 | jne                 8
            //   46                   | inc                 esi
            //   8975fc               | mov                 dword ptr [ebp - 4], esi

    condition:
        7 of them and filesize < 26230784
}