rule win_mewsei_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.mewsei."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mewsei"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7409 50 e8???????? 83c404 46 3bf3 72eb }
            // n = 7, score = 400
            //   7409                 | je                  0xb
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   46                   | inc                 esi
            //   3bf3                 | cmp                 esi, ebx
            //   72eb                 | jb                  0xffffffed

        $sequence_1 = { 895df4 8b5dfc 8dbc1f4239faff 8b5df4 }
            // n = 4, score = 400
            //   895df4               | mov                 dword ptr [ebp - 0xc], ebx
            //   8b5dfc               | mov                 ebx, dword ptr [ebp - 4]
            //   8dbc1f4239faff       | lea                 edi, [edi + ebx - 0x5c6be]
            //   8b5df4               | mov                 ebx, dword ptr [ebp - 0xc]

        $sequence_2 = { c1e810 33d2 25ff7f0000 f7f1 80c230 }
            // n = 5, score = 400
            //   c1e810               | shr                 eax, 0x10
            //   33d2                 | xor                 edx, edx
            //   25ff7f0000           | and                 eax, 0x7fff
            //   f7f1                 | div                 ecx
            //   80c230               | add                 dl, 0x30

        $sequence_3 = { ffd6 a1???????? 85c0 7405 6aff }
            // n = 5, score = 400
            //   ffd6                 | call                esi
            //   a1????????           |                     
            //   85c0                 | test                eax, eax
            //   7405                 | je                  7
            //   6aff                 | push                -1

        $sequence_4 = { 0bf3 0fb65804 c1e608 0bf3 8b5df8 33df 235dfc }
            // n = 7, score = 400
            //   0bf3                 | or                  esi, ebx
            //   0fb65804             | movzx               ebx, byte ptr [eax + 4]
            //   c1e608               | shl                 esi, 8
            //   0bf3                 | or                  esi, ebx
            //   8b5df8               | mov                 ebx, dword ptr [ebp - 8]
            //   33df                 | xor                 ebx, edi
            //   235dfc               | and                 ebx, dword ptr [ebp - 4]

        $sequence_5 = { 8b7df8 337df4 8b5df0 237dfc 337df8 037de0 8dbc1f2ac68747 }
            // n = 7, score = 400
            //   8b7df8               | mov                 edi, dword ptr [ebp - 8]
            //   337df4               | xor                 edi, dword ptr [ebp - 0xc]
            //   8b5df0               | mov                 ebx, dword ptr [ebp - 0x10]
            //   237dfc               | and                 edi, dword ptr [ebp - 4]
            //   337df8               | xor                 edi, dword ptr [ebp - 8]
            //   037de0               | add                 edi, dword ptr [ebp - 0x20]
            //   8dbc1f2ac68747       | lea                 edi, [edi + ebx + 0x4787c62a]

        $sequence_6 = { 85c0 750c 6a01 e8???????? 83c404 ebe7 894610 }
            // n = 7, score = 400
            //   85c0                 | test                eax, eax
            //   750c                 | jne                 0xe
            //   6a01                 | push                1
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   ebe7                 | jmp                 0xffffffe9
            //   894610               | mov                 dword ptr [esi + 0x10], eax

        $sequence_7 = { 0fb6581c 0bfb 897974 897de8 8b7df0 }
            // n = 5, score = 400
            //   0fb6581c             | movzx               ebx, byte ptr [eax + 0x1c]
            //   0bfb                 | or                  edi, ebx
            //   897974               | mov                 dword ptr [ecx + 0x74], edi
            //   897de8               | mov                 dword ptr [ebp - 0x18], edi
            //   8b7df0               | mov                 edi, dword ptr [ebp - 0x10]

        $sequence_8 = { 03de 8dbc3b44eabea4 8b5df4 c1c704 03fb 897dfc 8b7df8 }
            // n = 7, score = 400
            //   03de                 | add                 ebx, esi
            //   8dbc3b44eabea4       | lea                 edi, [ebx + edi - 0x5b4115bc]
            //   8b5df4               | mov                 ebx, dword ptr [ebp - 0xc]
            //   c1c704               | rol                 edi, 4
            //   03fb                 | add                 edi, ebx
            //   897dfc               | mov                 dword ptr [ebp - 4], edi
            //   8b7df8               | mov                 edi, dword ptr [ebp - 8]

        $sequence_9 = { 8bf8 897df8 c70300000000 8d7701 8d4900 56 e8???????? }
            // n = 7, score = 400
            //   8bf8                 | mov                 edi, eax
            //   897df8               | mov                 dword ptr [ebp - 8], edi
            //   c70300000000         | mov                 dword ptr [ebx], 0
            //   8d7701               | lea                 esi, [edi + 1]
            //   8d4900               | lea                 ecx, [ecx]
            //   56                   | push                esi
            //   e8????????           |                     

    condition:
        7 of them and filesize < 504832
}