rule win_mimikatz_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.mimikatz."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mimikatz"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { f7f1 85d2 7406 2bca }
            // n = 4, score = 300
            //   f7f1                 | div                 ecx
            //   85d2                 | test                edx, edx
            //   7406                 | je                  8
            //   2bca                 | sub                 ecx, edx

        $sequence_1 = { 83f8ff 750e ff15???????? c7002a000000 }
            // n = 4, score = 300
            //   83f8ff               | cmp                 eax, -1
            //   750e                 | jne                 0x10
            //   ff15????????         |                     
            //   c7002a000000         | mov                 dword ptr [eax], 0x2a

        $sequence_2 = { e8???????? 894720 85c0 7413 }
            // n = 4, score = 200
            //   e8????????           |                     
            //   894720               | mov                 dword ptr [edi + 0x20], eax
            //   85c0                 | test                eax, eax
            //   7413                 | je                  0x15

        $sequence_3 = { ff15???????? b9e9fd0000 8905???????? ff15???????? }
            // n = 4, score = 200
            //   ff15????????         |                     
            //   b9e9fd0000           | mov                 ecx, 0xfde9
            //   8905????????         |                     
            //   ff15????????         |                     

        $sequence_4 = { c3 81f998000000 7410 81f996000000 7408 81f99b000000 }
            // n = 6, score = 200
            //   c3                   | ret                 
            //   81f998000000         | cmp                 ecx, 0x98
            //   7410                 | je                  0x12
            //   81f996000000         | cmp                 ecx, 0x96
            //   7408                 | je                  0xa
            //   81f99b000000         | cmp                 ecx, 0x9b

        $sequence_5 = { 83f812 72f1 33c0 c3 }
            // n = 4, score = 200
            //   83f812               | cmp                 eax, 0x12
            //   72f1                 | jb                  0xfffffff3
            //   33c0                 | xor                 eax, eax
            //   c3                   | ret                 

        $sequence_6 = { ff5028 8be8 85c0 787a }
            // n = 4, score = 200
            //   ff5028               | call                dword ptr [eax + 0x28]
            //   8be8                 | mov                 ebp, eax
            //   85c0                 | test                eax, eax
            //   787a                 | js                  0x7c

        $sequence_7 = { f30f6f4928 f30f7f8c24a0000000 f30f6f4138 f30f7f8424b8000000 }
            // n = 4, score = 200
            //   f30f6f4928           | movdqu              xmm1, xmmword ptr [ecx + 0x28]
            //   f30f7f8c24a0000000     | movdqu    xmmword ptr [esp + 0xa0], xmm1
            //   f30f6f4138           | movdqu              xmm0, xmmword ptr [ecx + 0x38]
            //   f30f7f8424b8000000     | movdqu    xmmword ptr [esp + 0xb8], xmm0

        $sequence_8 = { 6683f83f 7607 32c0 e9???????? }
            // n = 4, score = 200
            //   6683f83f             | cmp                 ax, 0x3f
            //   7607                 | jbe                 9
            //   32c0                 | xor                 al, al
            //   e9????????           |                     

        $sequence_9 = { 66894108 33c0 39410c 740b }
            // n = 4, score = 200
            //   66894108             | mov                 word ptr [ecx + 8], ax
            //   33c0                 | xor                 eax, eax
            //   39410c               | cmp                 dword ptr [ecx + 0xc], eax
            //   740b                 | je                  0xd

        $sequence_10 = { ff15???????? b940000000 8bd0 89442430 }
            // n = 4, score = 200
            //   ff15????????         |                     
            //   b940000000           | mov                 ecx, 0x40
            //   8bd0                 | mov                 edx, eax
            //   89442430             | mov                 dword ptr [esp + 0x30], eax

        $sequence_11 = { e8???????? 8bf8 85f6 787a 813d????????401f0000 }
            // n = 5, score = 200
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   85f6                 | test                esi, esi
            //   787a                 | js                  0x7c
            //   813d????????401f0000     |     

        $sequence_12 = { 2bc1 85c9 7403 83c008 }
            // n = 4, score = 200
            //   2bc1                 | sub                 eax, ecx
            //   85c9                 | test                ecx, ecx
            //   7403                 | je                  5
            //   83c008               | add                 eax, 8

        $sequence_13 = { 3c02 7207 e8???????? eb10 }
            // n = 4, score = 200
            //   3c02                 | cmp                 al, 2
            //   7207                 | jb                  9
            //   e8????????           |                     
            //   eb10                 | jmp                 0x12

        $sequence_14 = { a3???????? a1???????? c705????????cf2f4000 8935???????? }
            // n = 4, score = 100
            //   a3????????           |                     
            //   a1????????           |                     
            //   c705????????cf2f4000     |     
            //   8935????????         |                     

        $sequence_15 = { 888898d34600 40 ebe9 33c0 8945e4 3d00010000 7d10 }
            // n = 7, score = 100
            //   888898d34600         | mov                 byte ptr [eax + 0x46d398], cl
            //   40                   | inc                 eax
            //   ebe9                 | jmp                 0xffffffeb
            //   33c0                 | xor                 eax, eax
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   3d00010000           | cmp                 eax, 0x100
            //   7d10                 | jge                 0x12

        $sequence_16 = { 57 e8???????? 8bf0 83c410 85f6 7415 }
            // n = 6, score = 100
            //   57                   | push                edi
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   83c410               | add                 esp, 0x10
            //   85f6                 | test                esi, esi
            //   7415                 | je                  0x17

        $sequence_17 = { 6a08 68???????? e8???????? 68???????? ff15???????? 8b7508 c7465c907f4000 }
            // n = 7, score = 100
            //   6a08                 | push                8
            //   68????????           |                     
            //   e8????????           |                     
            //   68????????           |                     
            //   ff15????????         |                     
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   c7465c907f4000       | mov                 dword ptr [esi + 0x5c], 0x407f90

        $sequence_18 = { 39b8a8d54600 0f8491000000 ff45e4 83c030 }
            // n = 4, score = 100
            //   39b8a8d54600         | cmp                 dword ptr [eax + 0x46d5a8], edi
            //   0f8491000000         | je                  0x97
            //   ff45e4               | inc                 dword ptr [ebp - 0x1c]
            //   83c030               | add                 eax, 0x30

        $sequence_19 = { 81ca00ffffff 42 0fb692b0e74600 321437 }
            // n = 4, score = 100
            //   81ca00ffffff         | or                  edx, 0xffffff00
            //   42                   | inc                 edx
            //   0fb692b0e74600       | movzx               edx, byte ptr [edx + 0x46e7b0]
            //   321437               | xor                 dl, byte ptr [edi + esi]

        $sequence_20 = { 8b4508 ff34c530d94600 ff15???????? 5d c3 6a0c 68???????? }
            // n = 7, score = 100
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   ff34c530d94600       | push                dword ptr [eax*8 + 0x46d930]
            //   ff15????????         |                     
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   6a0c                 | push                0xc
            //   68????????           |                     

        $sequence_21 = { 0fb6c8 51 e8???????? 83c404 85c0 7510 }
            // n = 6, score = 100
            //   0fb6c8               | movzx               ecx, al
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   85c0                 | test                eax, eax
            //   7510                 | jne                 0x12

    condition:
        7 of them and filesize < 1642496
}