rule win_miniasp_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.miniasp."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.miniasp"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83a5e8fbffff00 83a5f4fbffff00 8b85bcfbffff 83b81404000000 740f 8b85bcfbffff 83b814040000ff }
            // n = 7, score = 100
            //   83a5e8fbffff00       | and                 dword ptr [ebp - 0x418], 0
            //   83a5f4fbffff00       | and                 dword ptr [ebp - 0x40c], 0
            //   8b85bcfbffff         | mov                 eax, dword ptr [ebp - 0x444]
            //   83b81404000000       | cmp                 dword ptr [eax + 0x414], 0
            //   740f                 | je                  0x11
            //   8b85bcfbffff         | mov                 eax, dword ptr [ebp - 0x444]
            //   83b814040000ff       | cmp                 dword ptr [eax + 0x414], -1

        $sequence_1 = { c645fb00 8b45ec ffb098000000 6a00 8b45ec ffb0a4000000 8b45ec }
            // n = 7, score = 100
            //   c645fb00             | mov                 byte ptr [ebp - 5], 0
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   ffb098000000         | push                dword ptr [eax + 0x98]
            //   6a00                 | push                0
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   ffb0a4000000         | push                dword ptr [eax + 0xa4]
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]

        $sequence_2 = { 48 8985fcddffff 8b85fcddffff 8a4001 8885fbddffff ff85fcddffff 80bdfbddffff00 }
            // n = 7, score = 100
            //   48                   | dec                 eax
            //   8985fcddffff         | mov                 dword ptr [ebp - 0x2204], eax
            //   8b85fcddffff         | mov                 eax, dword ptr [ebp - 0x2204]
            //   8a4001               | mov                 al, byte ptr [eax + 1]
            //   8885fbddffff         | mov                 byte ptr [ebp - 0x2205], al
            //   ff85fcddffff         | inc                 dword ptr [ebp - 0x2204]
            //   80bdfbddffff00       | cmp                 byte ptr [ebp - 0x2205], 0

        $sequence_3 = { be???????? f3a5 a4 8b45bc 8b8098000000 48 8945a8 }
            // n = 7, score = 100
            //   be????????           |                     
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   a4                   | movsb               byte ptr es:[edi], byte ptr [esi]
            //   8b45bc               | mov                 eax, dword ptr [ebp - 0x44]
            //   8b8098000000         | mov                 eax, dword ptr [eax + 0x98]
            //   48                   | dec                 eax
            //   8945a8               | mov                 dword ptr [ebp - 0x58], eax

        $sequence_4 = { 2b856cffffff 898564ffffff 7507 32c0 e9???????? ff7510 ff750c }
            // n = 7, score = 100
            //   2b856cffffff         | sub                 eax, dword ptr [ebp - 0x94]
            //   898564ffffff         | mov                 dword ptr [ebp - 0x9c], eax
            //   7507                 | jne                 9
            //   32c0                 | xor                 al, al
            //   e9????????           |                     
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   ff750c               | push                dword ptr [ebp + 0xc]

        $sequence_5 = { 83ec18 894de8 6800c80000 e8???????? 59 8945fc }
            // n = 6, score = 100
            //   83ec18               | sub                 esp, 0x18
            //   894de8               | mov                 dword ptr [ebp - 0x18], ecx
            //   6800c80000           | push                0xc800
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   8945fc               | mov                 dword ptr [ebp - 4], eax

        $sequence_6 = { ff7508 6a00 ff15???????? 85c0 7505 }
            // n = 5, score = 100
            //   ff7508               | push                dword ptr [ebp + 8]
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7505                 | jne                 7

        $sequence_7 = { f3a4 8b4508 898550deffff 8b8550deffff 89854cdeffff 8b8550deffff 8a00 }
            // n = 7, score = 100
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   898550deffff         | mov                 dword ptr [ebp - 0x21b0], eax
            //   8b8550deffff         | mov                 eax, dword ptr [ebp - 0x21b0]
            //   89854cdeffff         | mov                 dword ptr [ebp - 0x21b4], eax
            //   8b8550deffff         | mov                 eax, dword ptr [ebp - 0x21b0]
            //   8a00                 | mov                 al, byte ptr [eax]

        $sequence_8 = { 68???????? 64a100000000 50 51 51 83ec34 53 }
            // n = 7, score = 100
            //   68????????           |                     
            //   64a100000000         | mov                 eax, dword ptr fs:[0]
            //   50                   | push                eax
            //   51                   | push                ecx
            //   51                   | push                ecx
            //   83ec34               | sub                 esp, 0x34
            //   53                   | push                ebx

        $sequence_9 = { 6804010000 e8???????? 59 8945d4 8b45d4 8945ec }
            // n = 6, score = 100
            //   6804010000           | push                0x104
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   8945d4               | mov                 dword ptr [ebp - 0x2c], eax
            //   8b45d4               | mov                 eax, dword ptr [ebp - 0x2c]
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax

    condition:
        7 of them and filesize < 139264
}